/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.AbstractIssueParserTest;
import edu.hm.hafner.analysis.AbstractParser;
import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.assertj.Assertions;
import edu.hm.hafner.analysis.assertj.SoftAssertions;
import edu.hm.hafner.analysis.parser.EclipseParser;
import java.util.Iterator;
import org.assertj.core.api.AbstractBooleanAssert;
import org.junit.jupiter.api.Test;

public class EclipseParserTest
extends AbstractIssueParserTest {
    protected EclipseParserTest() {
        super("eclipse.txt");
    }

    protected AbstractParser createParser() {
        return new EclipseParser();
    }

    @Override
    protected void assertThatIssuesArePresent(Report report, SoftAssertions softly) {
        Assertions.assertThat(report).hasSize(8);
        Issue annotation = report.get(0);
        softly.assertThat(annotation).hasSeverity(Severity.WARNING_NORMAL).hasLineStart(3).hasLineEnd(3).hasMessage("The serializable class AttributeException does not declare a static final serialVersionUID field of type long").hasFileName("C:/Desenvolvimento/Java/jfg/src/jfg/AttributeException.java");
    }

    @Test
    void issue21377() {
        Report warnings = this.parse("issue21377.txt");
        Assertions.assertThat(warnings).hasSize(1);
        SoftAssertions.assertSoftly(softly -> softly.assertThat(warnings.get(0)).hasSeverity(Severity.WARNING_NORMAL).hasLineStart(13).hasLineEnd(13).hasColumnStart(15).hasColumnEnd(28).hasMessage("The method getOldValue() from the type SomeType is deprecated").hasFileName("/path/to/job/job-name/module/src/main/java/com/example/Example.java"));
    }

    @Test
    void issue13969() {
        Report warnings = this.parse("issue13969.txt");
        Assertions.assertThat(warnings).hasSize(3);
        SoftAssertions.assertSoftly(softly -> {
            Iterator iterator = warnings.iterator();
            softly.assertThat((Issue)iterator.next()).hasSeverity(Severity.WARNING_NORMAL).hasLineStart(369).hasLineEnd(369).hasMessage("The method compare(List<String>, List<String>) from the type PmModelImporter is never used locally").hasFileName("/media/ssd/multi-x-processor/workspace/msgPM_Access/com.faktorzehn.pa2msgpm.core/src/com/faktorzehn/pa2msgpm/core/loader/PmModelImporter.java");
            softly.assertThat((Issue)iterator.next()).hasSeverity(Severity.WARNING_NORMAL).hasLineStart(391).hasLineEnd(391).hasMessage("The method getTableValues(PropertyRestrictionType) from the type PmModelImporter is never used locally").hasFileName("/media/ssd/multi-x-processor/workspace/msgPM_Access/com.faktorzehn.pa2msgpm.core/src/com/faktorzehn/pa2msgpm/core/loader/PmModelImporter.java");
            softly.assertThat((Issue)iterator.next()).hasSeverity(Severity.WARNING_NORMAL).hasLineStart(56).hasLineEnd(56).hasMessage("The value of the field PropertyImporterTest.ERROR_RESPONSE is not used").hasFileName("/media/ssd/multi-x-processor/workspace/msgPM_Access/com.faktorzehn.pa2msgpm.core.test/src/com/faktorzehn/pa2msgpm/core/importer/PropertyImporterTest.java");
        });
    }

    @Test
    void issue12822() {
        Report warnings = this.parse("issue12822.txt");
        Assertions.assertThat(warnings).hasSize(15);
    }

    @Test
    void issue6427() {
        Report warnings = this.parse("issue6427.txt");
        Assertions.assertThat(warnings).hasSize(18);
        SoftAssertions.assertSoftly(softly -> softly.assertThat(warnings.get(0)).hasSeverity(Severity.WARNING_NORMAL).hasLineStart(10).hasLineEnd(10).hasMessage("The import com.bombardier.oldinfra.export.dataAccess.InfrastructureDiagramAPI is never used").hasFileName("/srv/hudson/workspace/Ebitool Trunk/build/plugins/com.bombardier.oldInfra.export.jet/jet2java/org/eclipse/jet/compiled/_jet_infraSoe.java"));
    }

    @Test
    void issue7077() {
        Report warnings = this.parse("issue7077.txt");
        Assertions.assertThat(warnings).hasSize(2);
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(warnings.get(0)).hasSeverity(Severity.WARNING_NORMAL).hasLineStart(90).hasLineEnd(90).hasMessage("Type safety: The method setBoHandler(BoHandler) belongs to the raw type BoQuickSearchControl.Builder. References to generic type BoQuickSearchControl<S>.Builder<T> should be parameterized").hasFileName("/ige/hudson/work/jobs/esvclient__development/workspace/target/rcp-build/plugins/ch.ipi.esv.client.customer/src/main/java/ch/ipi/esv/client/customer/search/CustomerQuickSearch.java");
            softly.assertThat(warnings.get(1)).hasSeverity(Severity.WARNING_NORMAL).hasLineStart(90).hasLineEnd(90).hasMessage("Type safety: The expression of type BoQuickSearchControl needs unchecked conversion to conform to BoQuickSearchControl<CustomerBO>").hasFileName("/ige/hudson/work/jobs/esvclient__development/workspace/target/rcp-build/plugins/ch.ipi.esv.client.customer/src/main/java/ch/ipi/esv/client/customer/search/CustomerQuickSearch.java");
        });
    }

    @Test
    void issue7077all() {
        Report sorted = this.parse("issue7077-all.txt");
        Assertions.assertThat(sorted).hasSize(45);
        int number = 0;
        for (Issue fileAnnotation : sorted) {
            boolean containsHat = fileAnnotation.getMessage().contains("^");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)containsHat).withFailMessage("Message " + number + " contains ^", new Object[0])).isFalse();
            ++number;
        }
    }
}

