/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.util;

import edu.hm.hafner.util.Ensure;
import java.util.Collection;
import java.util.Collections;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Lists;
import org.junit.jupiter.api.Test;

class EnsureTest {
    private static final String SOME_STRING = "-";
    private static final String EMPTY_STRING = "";
    private static final String ERROR_MESSAGE = "assertThatThrownBy Error.";

    EnsureTest() {
    }

    @Test
    void shouldNotThrowExceptionIfContractIsValid() {
        Assertions.assertThatCode(() -> {
            Ensure.that((boolean)false).isFalse();
            Ensure.that((boolean)true).isTrue();
            Ensure.that((String)EMPTY_STRING).isNotNull();
            Ensure.that((Object)EMPTY_STRING, (Object[])new Object[]{EMPTY_STRING}).isNotNull();
            Ensure.that(null, (Object[])new Object[]{null}).isNull();
            Ensure.that((Object[])new String[]{EMPTY_STRING}).isNotEmpty();
            Ensure.that((String)SOME_STRING).isNotEmpty();
            Ensure.that((String)SOME_STRING).isNotBlank();
            Ensure.that((String)EMPTY_STRING).isInstanceOf(String.class, new Class[0]);
            Ensure.that(Collections.singleton(EMPTY_STRING)).isNotEmpty();
            Ensure.that(Collections.singleton(EMPTY_STRING)).contains((Object)EMPTY_STRING);
            Ensure.that(Collections.singleton(EMPTY_STRING)).doesNotContain((Object)SOME_STRING);
        }).doesNotThrowAnyException();
    }

    @Test
    void shouldThrowExceptionIfContractIsViolated() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Ensure.that((Throwable)new IllegalArgumentException(ERROR_MESSAGE)).isNeverThrown(ERROR_MESSAGE, new Object[0])).isInstanceOf(AssertionError.class)).hasMessage(ERROR_MESSAGE);
        Assertions.assertThatThrownBy(() -> Ensure.that((boolean)true).isFalse()).isInstanceOf(AssertionError.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Ensure.that((boolean)true).isFalse(ERROR_MESSAGE, new Object[0])).isInstanceOf(AssertionError.class)).hasMessage(ERROR_MESSAGE);
        Assertions.assertThatThrownBy(() -> Ensure.that((boolean)false).isTrue()).isInstanceOf(AssertionError.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Ensure.that((boolean)false).isTrue(ERROR_MESSAGE, new Object[0])).isInstanceOf(AssertionError.class)).hasMessage(ERROR_MESSAGE);
        Assertions.assertThatThrownBy(() -> Ensure.thatStatementIsNeverReached()).isInstanceOf(AssertionError.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Ensure.thatStatementIsNeverReached((String)ERROR_MESSAGE, (Object[])new Object[0])).isInstanceOf(AssertionError.class)).hasMessage(ERROR_MESSAGE);
        Assertions.assertThatThrownBy(() -> Ensure.that((String)SOME_STRING).isNull()).isInstanceOf(AssertionError.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Ensure.that((String)SOME_STRING).isNull(ERROR_MESSAGE, new Object[0])).isInstanceOf(AssertionError.class)).hasMessage(ERROR_MESSAGE);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Ensure.that((Object)SOME_STRING, (Object[])new Object[]{SOME_STRING}).isNull(ERROR_MESSAGE, new Object[0])).isInstanceOf(AssertionError.class)).hasMessage(ERROR_MESSAGE);
        Assertions.assertThatThrownBy(() -> Ensure.that(Collections.emptySet()).contains((Object)EMPTY_STRING)).isInstanceOf(AssertionError.class);
        Assertions.assertThatThrownBy(() -> Ensure.that(Collections.singleton(EMPTY_STRING)).contains((Object)SOME_STRING)).isInstanceOf(AssertionError.class);
        Assertions.assertThatThrownBy(() -> Ensure.that(Collections.singleton(EMPTY_STRING)).doesNotContain((Object)EMPTY_STRING)).isInstanceOf(AssertionError.class);
    }

    @Test
    void shouldThrowNpeIfContractIsViolated() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Ensure.that(null, (Object[])new Object[0]).isNotNull(ERROR_MESSAGE, new Object[0])).isInstanceOf(NullPointerException.class)).hasMessage(ERROR_MESSAGE);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Ensure.that((Object)SOME_STRING, (Object[])new Object[]{null}).isNotNull(ERROR_MESSAGE, new Object[0])).isInstanceOf(NullPointerException.class)).hasMessage(ERROR_MESSAGE);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Ensure.that(null, (Object[])new Object[]{SOME_STRING}).isNotNull(ERROR_MESSAGE, new Object[0])).isInstanceOf(NullPointerException.class)).hasMessage(ERROR_MESSAGE);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Ensure.that(null, (Object[])null).isNotNull(ERROR_MESSAGE, new Object[0])).isInstanceOf(NullPointerException.class)).hasMessage(ERROR_MESSAGE);
        Assertions.assertThatThrownBy(() -> Ensure.that(null, (Object[])new Object[0]).isNotNull()).isInstanceOf(NullPointerException.class);
        Assertions.assertThatThrownBy(() -> Ensure.that((Object)SOME_STRING, (Object[])new Object[]{null}).isNotNull()).isInstanceOf(NullPointerException.class);
        Assertions.assertThatThrownBy(() -> Ensure.that(null, (Object[])new Object[]{SOME_STRING}).isNotNull()).isInstanceOf(NullPointerException.class);
        Assertions.assertThatThrownBy(() -> Ensure.that(null, (Object[])null).isNotNull()).isInstanceOf(NullPointerException.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Ensure.that((Object[])null).isNotEmpty(ERROR_MESSAGE, new Object[0])).isInstanceOf(NullPointerException.class)).hasMessage(ERROR_MESSAGE);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Ensure.that((String)null).isNotEmpty(ERROR_MESSAGE, new Object[0])).isInstanceOf(NullPointerException.class)).hasMessage(ERROR_MESSAGE);
        Assertions.assertThatThrownBy(() -> Ensure.that((Object[])null).isNotEmpty()).isInstanceOf(NullPointerException.class);
        Assertions.assertThatThrownBy(() -> Ensure.that((String)null).isNotEmpty()).isInstanceOf(NullPointerException.class);
    }

    @Test
    void shouldThrowExceptionIfEmpty() {
        Assertions.assertThatThrownBy(() -> Ensure.that((Object[])new String[0]).isNotEmpty(ERROR_MESSAGE, new Object[0])).isInstanceOf(AssertionError.class);
        Assertions.assertThatThrownBy(() -> Ensure.that((Collection)Lists.newArrayList((Object[])new String[]{EMPTY_STRING, null, EMPTY_STRING})).isNotEmpty(ERROR_MESSAGE, new Object[0])).isInstanceOf(AssertionError.class);
        Assertions.assertThatThrownBy(() -> Ensure.that((Object[])new String[]{EMPTY_STRING, null, EMPTY_STRING}).isNotEmpty(ERROR_MESSAGE, new Object[0])).isInstanceOf(AssertionError.class);
        Assertions.assertThatThrownBy(() -> Ensure.that((String)EMPTY_STRING).isNotEmpty(ERROR_MESSAGE, new Object[0])).isInstanceOf(AssertionError.class);
        Assertions.assertThatThrownBy(() -> Ensure.that((String)" ").isNotBlank(ERROR_MESSAGE, new Object[0])).isInstanceOf(AssertionError.class);
        Assertions.assertThatThrownBy(() -> Ensure.that((String)EMPTY_STRING).isInstanceOf(Integer.class, ERROR_MESSAGE, new Object[0])).isInstanceOf(AssertionError.class);
        Assertions.assertThatThrownBy(() -> Ensure.that((Object[])new String[0]).isNotEmpty()).isInstanceOf(AssertionError.class);
        Assertions.assertThatThrownBy(() -> Ensure.that((Collection)Lists.newArrayList((Object[])new String[]{EMPTY_STRING, null, EMPTY_STRING})).isNotEmpty()).isInstanceOf(AssertionError.class);
        Assertions.assertThatThrownBy(() -> Ensure.that((Object[])new String[]{EMPTY_STRING, null, EMPTY_STRING}).isNotEmpty()).isInstanceOf(AssertionError.class);
        Assertions.assertThatThrownBy(() -> Ensure.that((String)EMPTY_STRING).isNotEmpty()).isInstanceOf(AssertionError.class);
        Assertions.assertThatThrownBy(() -> Ensure.that((String)" ").isNotBlank()).isInstanceOf(AssertionError.class);
        Assertions.assertThatThrownBy(() -> Ensure.that((String)EMPTY_STRING).isInstanceOf(Integer.class, ERROR_MESSAGE, new Object[0])).isInstanceOf(AssertionError.class);
    }

    @Test
    void shouldThrowExceptionWithCorrectMessage() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Ensure.that((String)EMPTY_STRING).isInstanceOf(Integer.class, "This error uses '%s' to print the number %d.", new Object[]{"String.format", 42})).isInstanceOf(AssertionError.class)).hasMessage("This error uses 'String.format' to print the number 42.");
    }
}

