/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.util;

import edu.hm.hafner.util.IntegerParser;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class IntegerParserTest {
    IntegerParserTest() {
    }

    @ParameterizedTest(name="[{index}] Illegal number = {0}")
    @ValueSource(strings={"text", "15x20", "\u0000 Null-Byte", "", " ", "23.5"})
    void shouldReturnDefaultValueOnInvalidValues(String invalidIntegerValue) {
        Assertions.assertThat((int)new IntegerParser().parseInt(invalidIntegerValue)).isZero();
    }

    @Test
    void shouldReturnValidInteger() {
        IntegerParser integerParser = new IntegerParser();
        Assertions.assertThat((int)integerParser.parseInt("0")).isZero();
        Assertions.assertThat((int)integerParser.parseInt("1")).isOne();
        Assertions.assertThat((int)integerParser.parseInt("1010")).isEqualTo(1010);
    }
}

