/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.ParsingCanceledException;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.util.IntegerParser;
import edu.hm.hafner.util.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.function.Function;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractParser
extends IssueParser {
    private static final long serialVersionUID = 8466657735514387654L;
    public static final String DEPRECATION = "Deprecation";
    public static final String PROPRIETARY_API = "Proprietary API";
    private String fileName = "-";

    public String getFileName() {
        return this.fileName;
    }

    @Override
    public Report parse(File file, Charset charset, Function<String, String> preProcessor) throws ParsingException, ParsingCanceledException {
        Report report;
        this.fileName = file.getAbsolutePath();
        FileInputStream inputStream = new FileInputStream(file);
        Throwable throwable = null;
        try {
            report = this.parse(inputStream, charset, preProcessor);
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    AbstractParser.$closeResource(throwable, inputStream);
                    throw throwable3;
                }
            }
            catch (FileNotFoundException exception) {
                throw new ParsingException(exception, "Can't find file: " + this.fileName);
            }
            catch (IOException exception) {
                throw new ParsingException(exception, "Can't scan file for issues: " + this.fileName);
            }
        }
        AbstractParser.$closeResource(throwable, inputStream);
        return report;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Report parse(InputStream inputStream, Charset charset, Function<String, String> preProcessor) {
        try (Reader input = this.createReader(inputStream, charset);){
            Report report = this.parse(input, preProcessor);
            return report;
        }
        catch (IOException exception) {
            throw new ParsingException(exception, "Can't scan file for issues: " + this.fileName);
        }
    }

    private Reader createReader(InputStream inputStream, Charset charset) {
        return new InputStreamReader((InputStream)new BOMInputStream(inputStream), charset);
    }

    public abstract Report parse(Reader var1, Function<String, String> var2) throws ParsingCanceledException, ParsingException;

    @VisibleForTesting
    public Report parse(Reader reader) throws ParsingCanceledException, ParsingException {
        return this.parse(reader, Function.identity());
    }

    protected int parseInt(@CheckForNull String lineNumber) {
        return new IntegerParser().parseInt(lineNumber);
    }

    protected String guessCategory(@CheckForNull String message) {
        if (StringUtils.contains((CharSequence)message, (CharSequence)"proprietary")) {
            return PROPRIETARY_API;
        }
        if (StringUtils.contains((CharSequence)message, (CharSequence)"deprecated")) {
            return DEPRECATION;
        }
        return "";
    }

    protected String guessCategoryIfEmpty(@CheckForNull String category, @CheckForNull String message) {
        String capitalized = StringUtils.capitalize((String)category);
        if (StringUtils.isEmpty((CharSequence)capitalized)) {
            capitalized = this.guessCategory(message);
        }
        return capitalized;
    }
}

