/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import edu.hm.hafner.analysis.AbstractPackageDetector;
import edu.hm.hafner.analysis.PackageDetectors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

class CSharpNamespaceDetector
extends AbstractPackageDetector {
    private static final Pattern NAMESPACE_PATTERN = Pattern.compile("^\\s*namespace\\s+([^{]*)\\s*\\{?\\s*$");

    CSharpNamespaceDetector() {
        this(new PackageDetectors.FileSystem());
    }

    CSharpNamespaceDetector(PackageDetectors.FileSystem fileSystem) {
        super(fileSystem);
    }

    @Override
    public boolean accepts(String fileName) {
        return fileName.endsWith(".cs");
    }

    @Override
    public String detectPackageName(Stream<String> lines) {
        return lines.map(NAMESPACE_PATTERN::matcher).filter(Matcher::matches).findFirst().map(matcher -> matcher.group(1)).orElse("-").trim();
    }
}

