/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import com.google.errorprone.annotations.FormatMethod;
import edu.hm.hafner.analysis.Report;

public class FilteredLog {
    private static final String SKIPPED_MESSAGE = "  ... skipped logging of %d additional errors ...";
    private final Report delegate;
    private final String title;
    private int lines = 0;

    public FilteredLog(Report report, String title) {
        this.delegate = report;
        this.title = title;
    }

    @FormatMethod
    public void logInfo(String format, Object ... args) {
        this.delegate.logInfo(format, args);
    }

    @FormatMethod
    public void logError(String format, Object ... args) {
        if (this.lines == 0) {
            this.delegate.logError("%s", this.title);
        }
        if (this.lines < 5) {
            this.delegate.logError(format, args);
        }
        ++this.lines;
    }

    public int size() {
        return this.lines;
    }

    public void logSummary() {
        if (this.lines > 5) {
            this.delegate.logError(SKIPPED_MESSAGE, this.lines - 5);
        }
    }
}

