/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import edu.hm.hafner.analysis.ParsingCanceledException;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.RegexpParser;
import edu.hm.hafner.analysis.Report;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class RegexpDocumentParser
extends RegexpParser {
    private static final long serialVersionUID = -4985090860783261124L;

    protected RegexpDocumentParser(String pattern, boolean useMultiLine) {
        super(pattern, useMultiLine);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Report parse(Reader reader, Function<String, String> preProcessor) throws ParsingCanceledException, ParsingException {
        try (BufferedReader bufferedReader = new BufferedReader(reader);){
            String text = bufferedReader.lines().map(preProcessor).collect(Collectors.joining("\n"));
            Report warnings = new Report();
            this.findIssues(text + "\n", warnings);
            Report report = warnings;
            return report;
        }
        catch (IOException e) {
            throw new ParsingException(e);
        }
    }
}

