/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import edu.hm.hafner.analysis.AbstractParser;
import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.ParsingCanceledException;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.Report;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class RegexpParser
extends AbstractParser {
    private static final long serialVersionUID = -82635675595933170L;
    protected static final Issue FALSE_POSITIVE = new IssueBuilder().build();
    protected static final String ANT_TASK = "^(?:.*\\[.*\\])?\\s*";
    private final Pattern pattern;

    protected RegexpParser(String pattern, boolean useMultiLine) {
        this.pattern = useMultiLine ? Pattern.compile(pattern, 8) : Pattern.compile(pattern);
    }

    protected void findIssues(String content, Report report) throws ParsingException, ParsingCanceledException {
        Matcher matcher = this.pattern.matcher(content);
        while (matcher.find()) {
            Issue warning = this.createIssue(matcher, new IssueBuilder());
            if (warning != FALSE_POSITIVE) {
                report.add(warning);
            }
            if (!Thread.interrupted()) continue;
            throw new ParsingCanceledException();
        }
    }

    protected abstract Issue createIssue(Matcher var1, IssueBuilder var2) throws ParsingException;
}

