/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlElementUtil {
    private XmlElementUtil() {
    }

    public static List<Element> getNamedChildElements(Element parent, String name) {
        ArrayList<Element> elements = new ArrayList<Element>();
        if (parent != null) {
            for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 1 || !child.getNodeName().equals(name)) continue;
                elements.add((Element)child);
            }
        }
        return elements;
    }

    @CheckForNull
    public static Element getFirstElementByTagName(Element parent, String tagName) {
        List<Element> foundElements = XmlElementUtil.getNamedChildElements(parent, tagName);
        if (foundElements.size() > 0) {
            return foundElements.get(0);
        }
        return null;
    }

    public static List<Element> nodeListToList(NodeList nodeList) {
        if (nodeList == null) {
            return Collections.EMPTY_LIST;
        }
        int length = nodeList.getLength();
        ArrayList<Element> elements = new ArrayList<Element>(length);
        for (int i = 0; i < length; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            elements.add((Element)node);
        }
        return elements;
    }
}

