/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.AbstractParser;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.Report;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.function.Function;
import java.util.regex.Pattern;

public class AjcParser
extends AbstractParser {
    private static final long serialVersionUID = -9123765511497052454L;
    private static final Pattern ESCAPE_CHARACTERS = Pattern.compile("\u001b\\[.*\u001b\\[0m");
    private static final Pattern WARNING_TAG = Pattern.compile("\\[WARNING\\] ");
    static final String ADVICE = "Advice";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Report parse(Reader reader, Function<String, String> preProcessor) throws ParsingException {
        try (BufferedReader br = new BufferedReader(reader);){
            String line;
            Report warnings = new Report();
            States state = States.START;
            IssueBuilder builder = new IssueBuilder();
            block16: while ((line = br.readLine()) != null) {
                line = ESCAPE_CHARACTERS.matcher(line).replaceAll("");
                switch (state) {
                    case START: {
                        if (!line.startsWith("[INFO] Showing AJC message detail for messages of types")) continue block16;
                        state = States.PARSING;
                        continue block16;
                    }
                    case PARSING: {
                        if (!line.startsWith("[WARNING] ")) continue block16;
                        state = States.WAITING_FOR_END;
                        this.fillMessageAndCategory(builder, line);
                        continue block16;
                    }
                    case WAITING_FOR_END: {
                        if (line.startsWith("\t")) {
                            this.fillFileName(builder, line);
                            continue block16;
                        }
                        if (!"".equals(line)) continue block16;
                        state = States.PARSING;
                        warnings.add(builder.build());
                        continue block16;
                    }
                }
            }
            Report report = warnings;
            return report;
        }
        catch (IOException e) {
            throw new ParsingException(e);
        }
    }

    private void fillFileName(IssueBuilder builder, String line) {
        int indexOfColon = line.lastIndexOf(58);
        if (indexOfColon != -1) {
            builder.setFileName(line.substring(0, indexOfColon));
            if (line.length() > indexOfColon + 1) {
                builder.setLineStart(this.parseInt(line.substring(indexOfColon + 1)));
            }
        }
    }

    private void fillMessageAndCategory(IssueBuilder builder, String line) {
        String message = WARNING_TAG.matcher(line).replaceAll("");
        String category = message.contains("is deprecated") || message.contains("overrides a deprecated") ? "Deprecation" : (message.contains("adviceDidNotMatch") ? ADVICE : "");
        builder.setMessage(message);
        builder.setCategory(category);
    }

    private static enum States {
        START,
        PARSING,
        WAITING_FOR_END;

    }
}

