/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.RegexpLineParser;
import edu.hm.hafner.analysis.Severity;
import java.util.regex.Matcher;

public class ArmccCompilerParser
extends RegexpLineParser {
    private static final long serialVersionUID = -2677728927938443703L;
    private static final String ARMCC_WARNING_PATTERN = "^\"(.+)\", line (\\d+): ([A-Z][a-z]+):\\D*(\\d+)\\D*?:\\s+(.+)$";

    public ArmccCompilerParser() {
        super(ARMCC_WARNING_PATTERN);
    }

    @Override
    protected Issue createIssue(Matcher matcher, IssueBuilder builder) {
        String fileName = matcher.group(1);
        int lineNumber = this.parseInt(matcher.group(2));
        String type = matcher.group(3);
        int errorCode = this.parseInt(matcher.group(4));
        String message = matcher.group(5);
        Severity priority = "error".equalsIgnoreCase(type) ? Severity.WARNING_HIGH : Severity.WARNING_NORMAL;
        return builder.setFileName(fileName).setLineStart(lineNumber).setMessage(errorCode + " - " + message).setSeverity(priority).build();
    }
}

