/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.RegexpLineParser;
import edu.hm.hafner.analysis.Severity;
import java.util.regex.Matcher;

public class CadenceIncisiveParser
extends RegexpLineParser {
    private static final long serialVersionUID = -3251791089328958452L;
    private static final String SLASH = "/";
    private static final String CADENCE_MESSAGE_PATTERN = "((^[a-zA-Z]+): \\*([a-zA-Z]),([a-zA-Z]+): (.*) \\[File:(.*), Line:(.*)\\].)|((^[a-zA-Z]+): \\*([a-zA-Z]),([a-zA-Z]+) \\((.*),([0-9]+)\\|([0-9]+)\\): (.*)$)|((^g?make\\[.*\\]: Entering directory)\\s*(['`]((.*))\\'))|((^[a-zA-Z]+): \\*([a-zA-Z]),([a-zA-Z]+): (.*)$)";
    private String directory = "";

    public CadenceIncisiveParser() {
        super(CADENCE_MESSAGE_PATTERN);
    }

    private Issue handleDirectory(Matcher matcher, int offset) {
        this.directory = matcher.group(offset) + SLASH;
        return FALSE_POSITIVE;
    }

    @Override
    protected Issue createIssue(Matcher matcher, IssueBuilder builder) {
        Severity priority;
        String message;
        String fileName;
        String category;
        String type;
        String tool;
        int lineNumber = 0;
        if (matcher.group(1) != null) {
            tool = matcher.group(2);
            type = matcher.group(3);
            category = matcher.group(4);
            fileName = matcher.group(6);
            lineNumber = this.parseInt(matcher.group(7));
            message = matcher.group(5);
            priority = Severity.WARNING_NORMAL;
        } else {
            if (matcher.group(16) != null) {
                return this.handleDirectory(matcher, 20);
            }
            if (matcher.group(8) != null) {
                tool = matcher.group(9);
                type = matcher.group(10);
                category = matcher.group(11);
                fileName = matcher.group(12);
                lineNumber = this.parseInt(matcher.group(13));
                message = matcher.group(15);
                priority = Severity.WARNING_NORMAL;
            } else if (matcher.group(21) != null) {
                tool = matcher.group(22);
                type = matcher.group(23);
                category = matcher.group(24);
                fileName = "/NotFileRelated";
                message = matcher.group(25);
                priority = Severity.WARNING_LOW;
            } else {
                return FALSE_POSITIVE;
            }
        }
        if ("E".equalsIgnoreCase(type)) {
            priority = Severity.WARNING_HIGH;
            category = "Error (" + tool + "): " + category;
        } else {
            category = "Warning (" + tool + "): " + category;
        }
        if (fileName == null) {
            return FALSE_POSITIVE;
        }
        if (fileName.startsWith(SLASH)) {
            return builder.setFileName(fileName).setLineStart(lineNumber).setCategory(category).setMessage(message).setSeverity(priority).build();
        }
        return builder.setFileName(this.directory + fileName).setLineStart(lineNumber).setCategory(category).setMessage(message).setSeverity(priority).build();
    }
}

