/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.RegexpLineParser;
import edu.hm.hafner.analysis.Severity;
import java.util.regex.Matcher;

public class ErlcParser
extends RegexpLineParser {
    private static final long serialVersionUID = 8986478184830773892L;
    private static final String ERLC_WARNING_PATTERN = "^(.+\\.(?:erl|yrl|mib|bin|rel|asn1|idl)):(\\d*): ([wW]arning: )?(.+)$";

    public ErlcParser() {
        super(ERLC_WARNING_PATTERN);
    }

    @Override
    protected Issue createIssue(Matcher matcher, IssueBuilder builder) {
        String category;
        Severity priority;
        String categoryMatch = matcher.group(3);
        if ("warning: ".equalsIgnoreCase(categoryMatch)) {
            priority = Severity.WARNING_NORMAL;
            category = categoryMatch.substring(0, categoryMatch.length() - 2);
        } else {
            priority = Severity.WARNING_HIGH;
            category = "Error";
        }
        return builder.setFileName(matcher.group(1)).setLineStart(this.parseInt(matcher.group(2))).setCategory(category).setMessage(matcher.group(4)).setSeverity(priority).build();
    }
}

