/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.FastRegexpLineParser;
import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.Severity;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Gcc4CompilerParser
extends FastRegexpLineParser {
    private static final long serialVersionUID = 5490211629355204910L;
    private static final String ERROR = "error";
    private static final String GCC_WARNING_PATTERN = "^(?:.*\\[.*\\])?\\s*(.+?):(\\d+):(?:(\\d+):)? (warning|.*error): (.*)$";
    private static final Pattern CLASS_PATTERN = Pattern.compile("\\[-W(.+)\\]$");

    public Gcc4CompilerParser() {
        super(GCC_WARNING_PATTERN);
    }

    @Override
    protected boolean isLineInteresting(String line) {
        return line.contains("warning") || line.contains(ERROR);
    }

    @Override
    protected Issue createIssue(Matcher matcher, IssueBuilder builder) {
        Severity priority;
        String message = matcher.group(5);
        StringBuilder category = new StringBuilder();
        if (matcher.group(4).contains(ERROR)) {
            priority = Severity.WARNING_HIGH;
            category.append("Error");
        } else {
            priority = Severity.WARNING_NORMAL;
            category.append("Warning");
            Matcher classMatcher = CLASS_PATTERN.matcher(message);
            if (classMatcher.find() && classMatcher.group(1) != null) {
                category.append(':').append(classMatcher.group(1));
            }
        }
        return builder.setFileName(matcher.group(1)).setLineStart(this.parseInt(matcher.group(2))).setColumnStart(this.parseInt(matcher.group(3))).setCategory(category.toString()).setMessage(message).setSeverity(priority).build();
    }
}

