/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.AbstractParser;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.XmlElementUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Function;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.commons.text.StringEscapeUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class IdeaInspectionParser
extends AbstractParser {
    private static final long serialVersionUID = 3307389086106375473L;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Report parse(Reader reader, Function<String, String> preProcessor) throws ParsingException {
        try (ReaderInputStream input = new ReaderInputStream(reader, StandardCharsets.UTF_8);){
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse((InputStream)input);
            Element rootElement = (Element)document.getElementsByTagName("problems").item(0);
            Report report = this.parseProblems(XmlElementUtil.getNamedChildElements(rootElement, "problem"));
            return report;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new ParsingException(e);
        }
    }

    private Report parseProblems(List<Element> elements) {
        Report problems = new Report();
        for (Element element : elements) {
            String file = this.getChildValue(element, "file");
            Element problemClass = XmlElementUtil.getFirstElementByTagName(element, "problem_class");
            if (problemClass == null) continue;
            IssueBuilder builder = new IssueBuilder().setFileName(file).setLineStart(Integer.parseInt(this.getChildValue(element, "line"))).setCategory(StringEscapeUtils.unescapeXml((String)this.getValue(problemClass))).setMessage(StringEscapeUtils.unescapeXml((String)this.getChildValue(element, "description"))).setSeverity(this.getPriority(problemClass.getAttribute("severity")));
            problems.add(builder.build());
        }
        return problems;
    }

    private Severity getPriority(String severity) {
        Severity priority = Severity.WARNING_LOW;
        if ("WARNING".equals(severity)) {
            priority = Severity.WARNING_NORMAL;
        } else if ("ERROR".equals(severity)) {
            priority = Severity.WARNING_HIGH;
        }
        return priority;
    }

    private String getValue(Element element) {
        return element.getFirstChild().getNodeValue();
    }

    private String getChildValue(Element element, String childTag) {
        Node child;
        Element firstElement = XmlElementUtil.getFirstElementByTagName(element, childTag);
        if (firstElement != null && (child = firstElement.getFirstChild()) != null) {
            return child.getNodeValue();
        }
        return "-";
    }
}

