/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.IntegerParser;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class JSLintXmlSaxParser
extends DefaultHandler {
    private final Report report;
    private String fileName = "";
    static final String CATEGORY_PARSING = "Parsing";
    static final String CATEGORY_UNDEFINED_VARIABLE = "Undefined Variable";
    static final String CATEGORY_FORMATTING = "Formatting";

    public JSLintXmlSaxParser(Report report) {
        this.report = report;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String key, Attributes atts) {
        if (this.isLintDerivate(key)) {
            return;
        }
        if ("file".equals(key)) {
            this.fileName = atts.getValue("name");
            return;
        }
        if ("issue".equals(key) || "error".equals(key)) {
            this.createWarning(atts);
        }
    }

    private void createWarning(Attributes attributes) {
        String category = "";
        Severity priority = Severity.WARNING_NORMAL;
        String message = this.extractFrom(attributes, "reason", "message");
        if (message.startsWith("Expected")) {
            priority = Severity.WARNING_HIGH;
            category = CATEGORY_PARSING;
        } else if (message.endsWith(" is not defined.")) {
            priority = Severity.WARNING_HIGH;
            category = CATEGORY_UNDEFINED_VARIABLE;
        } else if (message.contains("Mixed spaces and tabs")) {
            priority = Severity.WARNING_LOW;
            category = CATEGORY_FORMATTING;
        } else if (message.contains("Unnecessary semicolon")) {
            category = CATEGORY_FORMATTING;
        } else if (message.contains("is better written in dot notation")) {
            category = CATEGORY_FORMATTING;
        }
        int lineNumber = this.parseInt(attributes.getValue("line"));
        String column = this.extractFrom(attributes, "column", "char");
        IssueBuilder builder = new IssueBuilder().setFileName(this.fileName).setLineStart(lineNumber).setCategory(category).setMessage(message).setSeverity(priority);
        if (StringUtils.isNotBlank((CharSequence)column)) {
            builder.setColumnStart(this.parseInt(column));
        }
        this.report.add(builder.build());
    }

    private int parseInt(String line) {
        return new IntegerParser().parseInt(line);
    }

    private String extractFrom(Attributes atts, String first, String second) {
        String value = atts.getValue(first);
        if (StringUtils.isEmpty((CharSequence)value)) {
            value = atts.getValue(second);
        }
        return value;
    }

    private boolean isLintDerivate(String key) {
        return key != null && key.contains("lint");
    }
}

