/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.RegexpLineParser;
import edu.hm.hafner.analysis.Severity;
import java.util.regex.Matcher;

public class RuboCopParser
extends RegexpLineParser {
    private static final long serialVersionUID = 7199325311690082783L;
    private static final String RUBOCOP_WARNING_PATTERN = "^([^:]+):(\\d+):(\\d+): ([RCWEF]): (\\S+): (.*)$";

    public RuboCopParser() {
        super(RUBOCOP_WARNING_PATTERN);
    }

    @Override
    protected Issue createIssue(Matcher matcher, IssueBuilder builder) {
        String message = matcher.group(6);
        String category = this.guessCategoryIfEmpty(matcher.group(5), message);
        String severity = matcher.group(4);
        Severity priority = Severity.WARNING_NORMAL;
        if ("E".equals(severity) || "F".equals(severity)) {
            priority = Severity.WARNING_HIGH;
        }
        return builder.setFileName(matcher.group(1)).setLineStart(this.parseInt(matcher.group(2))).setCategory(category).setMessage(message).setSeverity(priority).setColumnStart(this.parseInt(matcher.group(3))).build();
    }
}

