/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.AbstractParser;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.ParsingCanceledException;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.XmlElementUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Function;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.input.ReaderInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class StyleCopParser
extends AbstractParser {
    private static final long serialVersionUID = 7846052338159003458L;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Report parse(Reader reader, Function<String, String> preProcessor) throws ParsingException, ParsingCanceledException {
        try (ReaderInputStream input = new ReaderInputStream(reader, StandardCharsets.UTF_8);){
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse((InputStream)input);
            NodeList mainNode = doc.getElementsByTagName("SourceAnalysisViolations");
            if (mainNode.getLength() == 0) {
                mainNode = doc.getElementsByTagName("StyleCopViolations");
            }
            Element rootElement = (Element)mainNode.item(0);
            Report report = this.parseViolations(XmlElementUtil.getNamedChildElements(rootElement, "Violation"));
            return report;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new ParsingException(e);
        }
    }

    private Report parseViolations(List<Element> elements) {
        Report report = new Report();
        for (Element element : elements) {
            IssueBuilder builder = new IssueBuilder().setFileName(this.getString(element, "Source")).setLineStart(this.getLineNumber(element)).setCategory(this.getCategory(element)).setType(this.getString(element, "Rule")).setMessage(element.getTextContent()).setSeverity(Severity.WARNING_NORMAL);
            report.add(builder.build());
        }
        return report;
    }

    private String getCategory(Element element) {
        String ruleNameSpace = this.getString(element, "RuleNamespace");
        int i = ruleNameSpace.lastIndexOf(46);
        if (i == -1) {
            return this.getString(element, "RuleId");
        }
        return ruleNameSpace.substring(i + 1);
    }

    private String getString(Element element, String name) {
        if (element.hasAttribute(name)) {
            return element.getAttribute(name);
        }
        return "";
    }

    private int getLineNumber(Element violation) {
        if (violation.hasAttribute("LineNumber")) {
            return this.parseInt(violation.getAttribute("LineNumber"));
        }
        return 0;
    }
}

