/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser.ccm;

import edu.hm.hafner.analysis.AbstractParser;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.ParsingCanceledException;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.SecureDigester;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.parser.ccm.Ccm;
import edu.hm.hafner.analysis.parser.ccm.Metric;
import java.io.IOException;
import java.io.Reader;
import java.util.function.Function;
import org.xml.sax.SAXException;

public class CcmParser
extends AbstractParser {
    private static final long serialVersionUID = -5172155190810975806L;

    @Override
    public Report parse(Reader reader, Function<String, String> preProcessor) throws ParsingCanceledException, ParsingException {
        try {
            Ccm module = this.parseCCMXmlFile(reader);
            if (module == null) {
                throw new SAXException("Input stream is not a CCM file.");
            }
            return this.convert(module);
        }
        catch (IOException | SAXException exception) {
            throw new ParsingException(exception);
        }
    }

    private Ccm parseCCMXmlFile(Reader ccmXmlFile) throws IOException, SAXException {
        SecureDigester digester = new SecureDigester(CcmParser.class);
        String rootXPath = "ccm";
        digester.addObjectCreate(rootXPath, Ccm.class);
        digester.addSetProperties(rootXPath);
        String fileMetric = "ccm/metric";
        digester.addObjectCreate(fileMetric, Metric.class);
        digester.addSetProperties(fileMetric);
        digester.addBeanPropertySetter("ccm/metric/complexity");
        digester.addBeanPropertySetter("ccm/metric/unit");
        digester.addBeanPropertySetter("ccm/metric/classification");
        digester.addBeanPropertySetter("ccm/metric/file");
        digester.addBeanPropertySetter("ccm/metric/startLineNumber");
        digester.addBeanPropertySetter("ccm/metric/endLineNumber");
        digester.addSetNext(fileMetric, "addMetric", Metric.class.getName());
        return (Ccm)digester.parse(ccmXmlFile);
    }

    private Report convert(Ccm collection) {
        Report report = new Report();
        for (Metric metric : collection.getMetrics()) {
            Severity priority = this.calculateMetricPriority(metric);
            String complexity = String.format("%s has a complexity of %d", metric.getUnit(), metric.getComplexity());
            IssueBuilder builder = new IssueBuilder();
            builder.setSeverity(priority).setMessage(complexity).setCategory(metric.getClassification()).setLineStart(metric.getStartLineNumber()).setLineEnd(metric.getEndLineNumber()).setFileName(metric.getFile());
            report.add(builder.build());
        }
        return report;
    }

    private Severity calculateMetricPriority(Metric metric) {
        if (this.isMetricHighPriority(metric)) {
            return Severity.WARNING_HIGH;
        }
        if (this.isMetricModeratePriority(metric)) {
            return Severity.WARNING_NORMAL;
        }
        return Severity.WARNING_LOW;
    }

    private boolean isMetricHighPriority(Metric metric) {
        String metricClassification = metric.getClassification();
        if (metricClassification.contains("high")) {
            return true;
        }
        return metricClassification.contentEquals("C") || metricClassification.contentEquals("D") || metricClassification.contentEquals("E") || metricClassification.contentEquals("F");
    }

    private boolean isMetricModeratePriority(Metric metric) {
        String metricClassification = metric.getClassification();
        if (metricClassification.contains("moderate")) {
            return true;
        }
        return metricClassification.contentEquals("B");
    }
}

