/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser.fxcop;

import edu.hm.hafner.analysis.AbstractParser;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.ParsingCanceledException;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.XmlElementUtil;
import edu.hm.hafner.analysis.parser.fxcop.FxCopRule;
import edu.hm.hafner.analysis.parser.fxcop.FxCopRuleSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.input.ReaderInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FxCopParser
extends AbstractParser {
    private static final long serialVersionUID = -7208558002331355408L;
    @SuppressFBWarnings(value={"UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR", "SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private transient Report warnings;
    @SuppressFBWarnings(value={"UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR", "SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private transient FxCopRuleSet ruleSet;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Report parse(Reader reader, Function<String, String> preProcessor) throws ParsingException, ParsingCanceledException {
        try (ReaderInputStream input = new ReaderInputStream(reader, StandardCharsets.UTF_8);){
            this.ruleSet = new FxCopRuleSet();
            this.warnings = new Report();
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse((InputStream)input);
            NodeList mainNode = doc.getElementsByTagName("FxCopReport");
            Element rootElement = (Element)mainNode.item(0);
            this.parseRules(XmlElementUtil.getFirstElementByTagName(rootElement, "Rules"));
            this.parseNamespaces(XmlElementUtil.getFirstElementByTagName(rootElement, "Namespaces"), null);
            this.parseTargets(XmlElementUtil.getFirstElementByTagName(rootElement, "Targets"));
            Report report = this.warnings;
            return report;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new ParsingException(e);
        }
    }

    private void parseRules(Element rulesElement) {
        if (rulesElement != null) {
            for (Element rule : XmlElementUtil.getNamedChildElements(rulesElement, "Rule")) {
                this.ruleSet.addRule(rule);
            }
        }
    }

    private void parseTargets(Element targetsElement) {
        if (targetsElement != null) {
            for (Element target : XmlElementUtil.getNamedChildElements(targetsElement, "Target")) {
                String name = this.getString(target, "Name");
                this.parseMessages(XmlElementUtil.getFirstElementByTagName(target, "Messages"), name);
                this.parseModules(XmlElementUtil.getFirstElementByTagName(target, "Modules"), name);
                this.parseResources(XmlElementUtil.getFirstElementByTagName(target, "Resources"), name);
            }
        }
    }

    private void parseResources(Element resources, String parentName) {
        if (resources != null) {
            for (Element target : XmlElementUtil.getNamedChildElements(resources, "Resource")) {
                String name = this.getString(target, "Name");
                this.parseMessages(XmlElementUtil.getFirstElementByTagName(target, "Messages"), name);
            }
        }
    }

    private void parseModules(Element modulesElement, String parentName) {
        if (modulesElement != null) {
            for (Element module : XmlElementUtil.getNamedChildElements(modulesElement, "Module")) {
                String name = this.getString(module, "Name");
                this.parseMessages(XmlElementUtil.getFirstElementByTagName(module, "Messages"), name);
                this.parseNamespaces(XmlElementUtil.getFirstElementByTagName(module, "Namespaces"), name);
            }
        }
    }

    private void parseNamespaces(Element namespacesElement, String parentName) {
        if (namespacesElement != null) {
            for (Element namespace : XmlElementUtil.getNamedChildElements(namespacesElement, "Namespace")) {
                String name = this.getString(namespace, "Name");
                this.parseMessages(XmlElementUtil.getFirstElementByTagName(namespace, "Messages"), name);
                this.parseTypes(XmlElementUtil.getFirstElementByTagName(namespace, "Types"), name);
            }
        }
    }

    private void parseTypes(Element typesElement, String parentName) {
        if (typesElement != null) {
            for (Element type : XmlElementUtil.getNamedChildElements(typesElement, "Type")) {
                String name = parentName + "." + this.getString(type, "Name");
                this.parseMessages(XmlElementUtil.getFirstElementByTagName(type, "Messages"), name);
                this.parseMembers(XmlElementUtil.getFirstElementByTagName(type, "Members"), name);
            }
        }
    }

    private void parseMembers(Element membersElement, String parentName) {
        if (membersElement != null) {
            for (Element member : XmlElementUtil.getNamedChildElements(membersElement, "Member")) {
                this.parseMember(member, parentName);
            }
        }
    }

    private void parseAccessors(Element accessorsElement, String parentName) {
        if (accessorsElement != null) {
            for (Element member : XmlElementUtil.getNamedChildElements(accessorsElement, "Accessor")) {
                this.parseMember(member, parentName);
            }
        }
    }

    private void parseMember(Element member, String parentName) {
        this.parseMessages(XmlElementUtil.getFirstElementByTagName(member, "Messages"), parentName);
        this.parseAccessors(XmlElementUtil.getFirstElementByTagName(member, "Accessors"), parentName);
    }

    private void parseMessages(Element messages, String parentName) {
        this.parseMessages(messages, parentName, null);
    }

    private void parseMessages(Element messages, String parentName, String subName) {
        if (messages != null) {
            for (Element message : XmlElementUtil.getNamedChildElements(messages, "Message")) {
                for (Element issue : XmlElementUtil.getNamedChildElements(message, "Issue")) {
                    this.parseIssue(issue, message, parentName, subName);
                }
            }
        }
    }

    private void parseIssue(Element issue, Element parent, String parentName, String subName) {
        FxCopRule rule;
        String typeName = this.getString(parent, "TypeName");
        String category = this.getString(parent, "Category");
        String checkId = this.getString(parent, "CheckId");
        String issueLevel = this.getString(issue, "Level");
        StringBuilder msgBuilder = new StringBuilder();
        if (subName != null) {
            msgBuilder.append(subName);
            msgBuilder.append(' ');
        }
        if ((rule = this.ruleSet.getRule(category, checkId)) == null) {
            msgBuilder.append(typeName);
        } else {
            msgBuilder.append("<a href=\"");
            msgBuilder.append(rule.getUrl());
            msgBuilder.append("\">");
            msgBuilder.append(typeName);
            msgBuilder.append("</a>");
        }
        msgBuilder.append(" - ");
        msgBuilder.append(issue.getTextContent());
        String filePath = this.getString(issue, "Path");
        String fileName = this.getString(issue, "File");
        String fileLine = this.getString(issue, "Line");
        IssueBuilder builder = new IssueBuilder().setFileName(filePath + "/" + fileName).setLineStart(this.parseInt(fileLine)).setCategory(category).setMessage(msgBuilder.toString()).setSeverity(this.getPriority(issueLevel));
        if (rule != null) {
            builder.setDescription(rule.getDescription());
        }
        this.warnings.add(builder.build());
    }

    private String getString(Element element, String name) {
        if (element.hasAttribute(name)) {
            return element.getAttribute(name);
        }
        return "";
    }

    private Severity getPriority(String issueLevel) {
        if (issueLevel.contains("Error") || issueLevel.contains("Critical")) {
            return Severity.WARNING_HIGH;
        }
        if (issueLevel.contains("Warning")) {
            return Severity.WARNING_NORMAL;
        }
        return Severity.WARNING_LOW;
    }
}

