/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser.pmd;

import edu.hm.hafner.analysis.AbstractParser;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.ParsingCanceledException;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.SecureDigester;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.parser.pmd.File;
import edu.hm.hafner.analysis.parser.pmd.Pmd;
import edu.hm.hafner.analysis.parser.pmd.Violation;
import java.io.IOException;
import java.io.Reader;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXException;

public class PmdParser
extends AbstractParser {
    private static final long serialVersionUID = 6507147028628714706L;
    private static final int PMD_PRIORITY_MAPPED_TO_HIGH_PRIORITY = 3;
    private static final int PMD_PRIORITY_MAPPED_TO_LOW_PRIORITY = 4;

    @Override
    public Report parse(Reader reader, Function<String, String> preProcessor) throws ParsingCanceledException, ParsingException {
        try {
            SecureDigester digester = new SecureDigester(PmdParser.class);
            String rootXPath = "pmd";
            digester.addObjectCreate(rootXPath, Pmd.class);
            digester.addSetProperties(rootXPath);
            String fileXPath = "pmd/file";
            digester.addObjectCreate(fileXPath, File.class);
            digester.addSetProperties(fileXPath);
            digester.addSetNext(fileXPath, "addFile", File.class.getName());
            String bugXPath = "pmd/file/violation";
            digester.addObjectCreate(bugXPath, Violation.class);
            digester.addSetProperties(bugXPath);
            digester.addCallMethod(bugXPath, "setMessage", 0);
            digester.addSetNext(bugXPath, "addViolation", Violation.class.getName());
            Pmd pmd = (Pmd)digester.parse(reader);
            if (pmd == null) {
                throw new ParsingException("Input stream is not a PMD file.");
            }
            return this.convert(pmd);
        }
        catch (IOException | SAXException exception) {
            throw new ParsingException(exception);
        }
    }

    private Report convert(Pmd pmdIssues) {
        Report report = new Report();
        for (File file : pmdIssues.getFiles()) {
            for (Violation warning : file.getViolations()) {
                IssueBuilder builder = new IssueBuilder().setSeverity(this.mapPriority(warning)).setMessage(this.createMessage(warning)).setCategory(warning.getRuleset()).setType(warning.getRule()).setLineStart(warning.getBeginline()).setLineEnd(warning.getEndline()).setPackageName(warning.getPackage()).setFileName(file.getName()).setColumnStart(warning.getBegincolumn()).setColumnEnd(warning.getEndcolumn());
                report.add(builder.build());
            }
        }
        return report;
    }

    private Severity mapPriority(Violation warning) {
        if (warning.getPriority() < 3) {
            return Severity.WARNING_HIGH;
        }
        if (warning.getPriority() > 4) {
            return Severity.WARNING_LOW;
        }
        return Severity.WARNING_NORMAL;
    }

    private String createMessage(Violation warning) {
        String original = warning.getMessage();
        if (StringUtils.endsWith((CharSequence)original, (CharSequence)".")) {
            return original;
        }
        return original + ".";
    }
}

