/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import com.google.errorprone.annotations.FormatMethod;
import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.LineRangeList;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.Ensure;
import edu.hm.hafner.util.NoSuchElementException;
import edu.hm.hafner.util.PathUtil;
import edu.hm.hafner.util.TreeString;
import edu.hm.hafner.util.TreeStringBuilder;
import edu.hm.hafner.util.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class Report
implements Iterable<Issue>,
Serializable {
    private static final long serialVersionUID = 4L;
    @VisibleForTesting
    static final String DEFAULT_ID = "-";
    private String id;
    private String name;
    private String originReportFile;
    private List<Report> subReports = new ArrayList<Report>();
    private Set<Issue> elements = new LinkedHashSet<Issue>();
    private List<String> infoMessages = new ArrayList<String>();
    private List<String> errorMessages = new ArrayList<String>();
    private Map<String, Integer> countersByKey = new HashMap<String, Integer>();
    @CheckForNull
    private transient Set<String> fileNames;
    @CheckForNull
    private transient Map<String, String> namesByOrigin;
    private int duplicatesSize = 0;

    public Report() {
        this(DEFAULT_ID, DEFAULT_ID, DEFAULT_ID);
    }

    public Report(String id, String name) {
        this(id, name, DEFAULT_ID);
    }

    public Report(String id, String name, String originReportFile) {
        this.id = id;
        this.name = name;
        this.originReportFile = originReportFile;
    }

    public String getId() {
        return this.id;
    }

    private boolean hasId() {
        return !DEFAULT_ID.equals(this.id) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.id});
    }

    public String getEffectiveId() {
        Set ids = this.subReports.stream().map(Report::getEffectiveId).collect(Collectors.toSet());
        ids.add(this.getId());
        ids.remove(DEFAULT_ID);
        if (ids.size() == 1) {
            return (String)ids.iterator().next();
        }
        return this.getId();
    }

    public String getName() {
        return this.name;
    }

    public void setOrigin(String originId, String originName) {
        Ensure.that((String)originId).isNotBlank("Issue origin ID '%s' must be not blank (%s)", new Object[]{originId, this.toString()});
        Ensure.that((String)originName).isNotBlank("Issue origin name '%s' must be not blank (%s)", new Object[]{originName, this.toString()});
        this.id = originId;
        this.name = originName;
        this.stream().forEach(issue -> issue.setOrigin(originId, originName));
    }

    public String getEffectiveName() {
        Set names = this.subReports.stream().map(Report::getEffectiveName).collect(Collectors.toSet());
        names.add(this.getName());
        names.remove(DEFAULT_ID);
        if (names.size() == 1) {
            return (String)names.iterator().next();
        }
        return this.getName();
    }

    public String getOriginReportFile() {
        return this.originReportFile;
    }

    public void setOriginReportFile(String originReportFile) {
        this.originReportFile = new PathUtil().getAbsolutePath(originReportFile);
    }

    public Set<String> getOriginReportFiles() {
        Set<String> files = this.subReports.stream().map(Report::getOriginReportFiles).flatMap(Collection::stream).collect(Collectors.toSet());
        files.add(this.getOriginReportFile());
        files.remove(DEFAULT_ID);
        return files;
    }

    public Report(Report ... reports) {
        this();
        Ensure.that((Object[])reports).isNotEmpty("No reports given.", new Object[0]);
        this.subReports.addAll(Arrays.asList(reports));
    }

    public Report(Collection<? extends Report> reports) {
        this();
        Ensure.that(reports).isNotEmpty("No reports given.", new Object[0]);
        this.subReports.addAll(reports);
    }

    public Report add(Issue issue) {
        if (this.hasId() && !issue.hasOrigin()) {
            issue.setOrigin(this.id, this.name);
        }
        if (this.elements.contains(issue)) {
            ++this.duplicatesSize;
        } else {
            this.elements.add(issue);
        }
        return this;
    }

    public Report addAll(Issue issue, Issue ... additionalIssues) {
        this.add(issue);
        for (Issue additional : additionalIssues) {
            this.add(additional);
        }
        return this;
    }

    public Report addAll(Collection<? extends Issue> issues) {
        for (Issue issue : issues) {
            this.add(issue);
        }
        return this;
    }

    public Report addAll(Report ... reports) {
        Ensure.that((Object[])reports).isNotEmpty("No reports given.", new Object[0]);
        this.subReports.addAll(Arrays.asList(reports));
        return this;
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="Deserialization of instances that do not have all fields yet")
    protected Object readResolve() {
        if (this.countersByKey == null) {
            this.countersByKey = new HashMap<String, Integer>();
        }
        if (this.subReports == null) {
            this.subReports = new ArrayList<Report>();
            this.id = DEFAULT_ID;
            this.name = DEFAULT_ID;
            this.originReportFile = DEFAULT_ID;
        }
        return this;
    }

    Issue remove(UUID issueId) {
        Optional<Issue> issue = this.removeIfContained(issueId);
        if (issue.isPresent()) {
            return issue.get();
        }
        throw new NoSuchElementException("No removed found with id %s.", new Object[]{issueId});
    }

    private Optional<Issue> removeIfContained(UUID issueId) {
        Optional<Issue> issue = this.find(issueId);
        issue.ifPresent(value -> this.elements.remove(value));
        if (issue.isPresent()) {
            return issue;
        }
        for (Report subReport : this.subReports) {
            issue = subReport.removeIfContained(issueId);
            if (!issue.isPresent()) continue;
            return issue;
        }
        return Optional.empty();
    }

    private Optional<Issue> find(UUID issueId) {
        return this.elements.stream().filter((? super T issue) -> issue.getId().equals(issueId)).findAny();
    }

    public Issue findById(UUID issueId) {
        return this.stream().filter((? super T issue) -> issue.getId().equals(issueId)).findAny().orElseThrow(() -> new NoSuchElementException("No issue found with id %s.", new Object[]{issueId}));
    }

    public Set<Issue> findByProperty(Predicate<? super Issue> criterion) {
        return this.filterElements(criterion).collect(Collectors.toSet());
    }

    public Report filter(Predicate<? super Issue> criterion) {
        Report filtered = this.copyEmptyInstance();
        filtered.addAll(this.elements.stream().filter(criterion).collect(Collectors.toList()));
        for (Report subReport : this.subReports) {
            filtered.addAll(subReport.filter(criterion));
        }
        return filtered;
    }

    private Stream<Issue> filterElements(Predicate<? super Issue> criterion) {
        return this.stream().filter(criterion);
    }

    @Override
    @NonNull
    public Iterator<Issue> iterator() {
        return this.stream().iterator();
    }

    public Stream<Issue> stream() {
        return Stream.concat(this.elements.stream(), this.subReports.stream().flatMap(Report::stream));
    }

    public Collection<Issue> get() {
        return this.stream().collect(Collectors.toList());
    }

    public int size() {
        return this.elements.size() + this.subReports.stream().mapToInt(Report::size).sum();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public int getSize() {
        return this.size();
    }

    public int getDuplicatesSize() {
        return this.duplicatesSize + this.subReports.stream().mapToInt(Report::getDuplicatesSize).sum();
    }

    public int getSizeOf(String severity) {
        return this.getSizeOf(Severity.valueOf(severity));
    }

    public int getSizeOf(Severity severity) {
        return this.stream().filter((? super T issue) -> issue.getSeverity().equals(severity)).mapToInt(e -> 1).sum();
    }

    public Issue get(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("No such index " + index + " in " + this);
        }
        Iterator<Issue> all = this.iterator();
        for (int i = 0; i < index; ++i) {
            all.next();
        }
        return all.next();
    }

    public String toString() {
        return String.format("%s (%s): %d issues (%d duplicates)", this.getEffectiveName(), this.getEffectiveId(), this.size(), this.getDuplicatesSize());
    }

    public void print(IssuePrinter issuePrinter) {
        this.forEach(issuePrinter::print);
    }

    public Set<String> getModules() {
        return this.getProperties(Issue::getModuleName);
    }

    public boolean hasModules() {
        return this.hasProperty(this.getModules());
    }

    private boolean hasProperty(Set<String> propertyValues) {
        return propertyValues.size() > 1 || this.hasMeaningfulValues(propertyValues);
    }

    private boolean hasMeaningfulValues(Set<String> propertyValue) {
        return propertyValue.size() == 1 && !propertyValue.contains(DEFAULT_ID) && !propertyValue.contains("");
    }

    public Set<String> getPackages() {
        return this.getProperties(Issue::getPackageName);
    }

    public boolean hasPackages() {
        return this.hasProperty(this.getPackages());
    }

    public Set<String> getFolders() {
        return this.getProperties(Issue::getFolder);
    }

    public boolean hasFolders() {
        Set<String> packages = this.getPackages();
        packages.remove(DEFAULT_ID);
        return this.hasProperty(this.getFolders()) && packages.isEmpty();
    }

    public Set<String> getAbsolutePaths() {
        return this.getProperties(Issue::getAbsolutePath);
    }

    public Set<String> getFiles() {
        return this.getProperties(Issue::getFileName);
    }

    public boolean hasFiles() {
        return this.hasProperty(this.getFiles());
    }

    public Set<String> getCategories() {
        return this.getProperties(Issue::getCategory);
    }

    public boolean hasCategories() {
        return this.hasProperty(this.getCategories());
    }

    public Set<String> getTypes() {
        return this.getProperties(Issue::getType);
    }

    public boolean hasTypes() {
        return this.hasProperty(this.getTypes());
    }

    public Set<String> getTools() {
        return this.getProperties(Issue::getOrigin);
    }

    public boolean hasTools() {
        return this.hasProperty(this.getTools());
    }

    public Set<Severity> getSeverities() {
        return this.getProperties(Issue::getSeverity);
    }

    public boolean hasSeverities() {
        return this.getSeverities().size() > 1;
    }

    public <T> Set<T> getProperties(Function<? super Issue, T> propertiesMapper) {
        return this.stream().map(propertiesMapper).collect(Collectors.toSet());
    }

    public <T> Map<T, Integer> getPropertyCount(Function<? super Issue, T> propertiesMapper) {
        return this.stream().collect(Collectors.groupingBy(propertiesMapper, Collectors.reducing(0, issue -> 1, Integer::sum)));
    }

    public Map<String, Report> groupByProperty(String propertyName) {
        Map<String, List<Issue>> issues = this.stream().collect(Collectors.groupingBy(Issue.getPropertyValueGetter(propertyName)));
        return issues.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            Report report = new Report();
            report.addAll((Collection)e.getValue());
            return report;
        }));
    }

    public Report copy() {
        Report copied = new Report();
        this.copyIssuesAndProperties(this, copied);
        return copied;
    }

    private void copyIssuesAndProperties(Report source, Report destination) {
        destination.addAll(source.elements);
        for (Report subReport : this.subReports) {
            destination.addAll(subReport.copy());
        }
        this.copyProperties(source, destination);
    }

    private void copyProperties(Report source, Report destination) {
        destination.id = source.id;
        destination.name = source.name;
        destination.originReportFile = source.originReportFile;
        destination.duplicatesSize += source.duplicatesSize;
        destination.infoMessages.addAll(source.infoMessages);
        destination.errorMessages.addAll(source.errorMessages);
        destination.countersByKey = Stream.concat(destination.countersByKey.entrySet().stream(), source.countersByKey.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Integer::sum));
    }

    public Report copyEmptyInstance() {
        Report empty = new Report();
        this.copyProperties(this, empty);
        return empty;
    }

    @FormatMethod
    public void logInfo(String format, Object ... args) {
        this.infoMessages.add(String.format(format, args));
    }

    @FormatMethod
    public void logError(String format, Object ... args) {
        this.errorMessages.add(String.format(format, args));
    }

    @FormatMethod
    public void logException(Exception exception, String format, Object ... args) {
        this.logError(format, args);
        Collections.addAll(this.errorMessages, ExceptionUtils.getRootCauseStackTrace((Throwable)exception));
    }

    public List<String> getInfoMessages() {
        return this.mergeMessages(this.infoMessages, Report::getInfoMessages);
    }

    public List<String> getErrorMessages() {
        return this.mergeMessages(this.errorMessages, Report::getErrorMessages);
    }

    private List<String> mergeMessages(List<String> thisMessages, Function<Report, List<String>> sumMessages) {
        return Stream.concat(this.subReports.stream().map(sumMessages).flatMap(Collection::stream), thisMessages.stream()).collect(Collectors.toList());
    }

    public boolean hasErrors() {
        return !this.getErrorMessages().isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Report report = (Report)o;
        if (this.duplicatesSize != report.duplicatesSize) {
            return false;
        }
        if (!this.id.equals(report.id)) {
            return false;
        }
        if (!this.name.equals(report.name)) {
            return false;
        }
        if (!this.originReportFile.equals(report.originReportFile)) {
            return false;
        }
        if (!this.subReports.equals(report.subReports)) {
            return false;
        }
        if (!this.elements.equals(report.elements)) {
            return false;
        }
        if (!this.infoMessages.equals(report.infoMessages)) {
            return false;
        }
        if (!this.errorMessages.equals(report.errorMessages)) {
            return false;
        }
        return this.countersByKey.equals(report.countersByKey);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.originReportFile.hashCode();
        result = 31 * result + this.subReports.hashCode();
        result = 31 * result + this.elements.hashCode();
        result = 31 * result + this.infoMessages.hashCode();
        result = 31 * result + this.errorMessages.hashCode();
        result = 31 * result + this.countersByKey.hashCode();
        result = 31 * result + this.duplicatesSize;
        return result;
    }

    private void writeObject(ObjectOutputStream output) throws IOException {
        output.writeInt(this.elements.size());
        this.writeIssues(output);
        output.writeObject(this.infoMessages);
        output.writeObject(this.errorMessages);
        output.writeObject(this.countersByKey);
        output.writeInt(this.duplicatesSize);
        output.writeUTF(this.id);
        output.writeUTF(this.name);
        output.writeUTF(this.originReportFile);
        output.writeInt(this.subReports.size());
        for (Report subReport : this.subReports) {
            output.writeObject(subReport);
        }
    }

    private void writeIssues(ObjectOutputStream output) throws IOException {
        for (Issue issue : this.elements) {
            output.writeUTF(issue.getPath());
            output.writeUTF(issue.getFileName());
            output.writeInt(issue.getLineStart());
            output.writeInt(issue.getLineEnd());
            output.writeInt(issue.getColumnStart());
            output.writeInt(issue.getColumnEnd());
            output.writeObject(issue.getLineRanges());
            output.writeUTF(issue.getCategory());
            output.writeUTF(issue.getType());
            output.writeUTF(issue.getPackageName());
            output.writeUTF(issue.getModuleName());
            output.writeUTF(issue.getSeverity().getName());
            this.writeLongString(output, issue.getMessage());
            this.writeLongString(output, issue.getDescription());
            output.writeUTF(issue.getOrigin());
            output.writeUTF(issue.getOriginName());
            output.writeUTF(issue.getReference());
            output.writeUTF(issue.getFingerprint());
            output.writeObject(issue.getAdditionalProperties());
            output.writeObject(issue.getId());
        }
    }

    private void writeLongString(ObjectOutputStream output, String value) throws IOException {
        output.writeInt(value.length());
        output.writeChars(value);
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        this.elements = new LinkedHashSet<Issue>();
        this.readIssues(input, input.readInt());
        this.infoMessages = (List)input.readObject();
        this.errorMessages = (List)input.readObject();
        this.countersByKey = (Map)input.readObject();
        this.duplicatesSize = input.readInt();
        this.id = input.readUTF();
        this.name = input.readUTF();
        this.originReportFile = input.readUTF();
        this.subReports = new ArrayList<Report>();
        int subReportCount = input.readInt();
        for (int i = 0; i < subReportCount; ++i) {
            Report subReport = (Report)input.readObject();
            this.subReports.add(subReport);
        }
    }

    @SuppressFBWarnings(value={"OBJECT_DESERIALIZATION"})
    private void readIssues(ObjectInputStream input, int size) throws IOException, ClassNotFoundException {
        TreeStringBuilder builder = new TreeStringBuilder();
        for (int i = 0; i < size; ++i) {
            String path = input.readUTF();
            TreeString fileName = builder.intern(input.readUTF());
            int lineStart = input.readInt();
            int lineEnd = input.readInt();
            int columnStart = input.readInt();
            int columnEnd = input.readInt();
            LineRangeList lineRanges = (LineRangeList)input.readObject();
            String category = input.readUTF();
            String type = input.readUTF();
            TreeString packageName = builder.intern(input.readUTF());
            String moduleName = input.readUTF();
            Severity severity = Severity.valueOf(input.readUTF());
            TreeString message = builder.intern(this.readLongString(input));
            String description = this.readLongString(input);
            String origin = input.readUTF();
            String originName = input.readUTF();
            String reference = input.readUTF();
            String fingerprint = input.readUTF();
            Serializable additionalProperties = (Serializable)input.readObject();
            UUID uuid = (UUID)input.readObject();
            Issue issue = new Issue(path, fileName, lineStart, lineEnd, columnStart, columnEnd, lineRanges, category, type, packageName, moduleName, severity, message, description, origin, originName, reference, fingerprint, additionalProperties, uuid);
            this.elements.add(issue);
        }
        builder.dedup();
    }

    private String readLongString(ObjectInputStream input) throws IOException {
        int messageLength = input.readInt();
        if (messageLength < 0) {
            throw new IllegalStateException("Can't read requested number of characters " + messageLength);
        }
        char[] chars = new char[messageLength];
        for (int j = 0; j < chars.length; ++j) {
            chars[j] = input.readChar();
        }
        return new String(chars);
    }

    public String getNameOfOrigin(String origin) {
        if (this.getId().equals(origin)) {
            return this.getName();
        }
        for (Report subReport : this.subReports) {
            String nameOfSubReport = subReport.getNameOfOrigin(origin);
            if (DEFAULT_ID.equals(nameOfSubReport)) continue;
            return nameOfSubReport;
        }
        return DEFAULT_ID;
    }

    public void setCounter(String key, int value) {
        this.countersByKey.put(Objects.requireNonNull(key), value);
    }

    public int getCounter(String key) {
        return this.countersByKey.getOrDefault(key, 0) + this.subReports.stream().mapToInt(r -> r.getCounter(key)).sum();
    }

    public boolean hasCounter(String key) {
        return this.countersByKey.containsKey(key);
    }

    public static class IssueFilterBuilder {
        private final Collection<Predicate<Issue>> includeFilters = new ArrayList<Predicate<Issue>>();
        private final Collection<Predicate<Issue>> excludeFilters = new ArrayList<Predicate<Issue>>();

        private void addNewFilter(Collection<String> patterns, Function<Issue, String> propertyToFilter, FilterType type) {
            ArrayList<Predicate<Issue>> filters = new ArrayList<Predicate<Issue>>();
            for (String pattern : patterns) {
                filters.add(issueToFilter -> Pattern.compile(pattern, 32).matcher((CharSequence)propertyToFilter.apply((Issue)issueToFilter)).find() == (type == FilterType.INCLUDE));
            }
            if (type == FilterType.INCLUDE) {
                this.includeFilters.addAll(filters);
            } else {
                this.excludeFilters.addAll(filters);
            }
        }

        public Predicate<Issue> build() {
            return this.includeFilters.stream().reduce(Predicate::or).orElse(issue -> true).and(this.excludeFilters.stream().reduce(Predicate::and).orElse(issue -> true));
        }

        public IssueFilterBuilder setIncludeFileNameFilter(Collection<String> pattern) {
            this.addNewFilter(pattern, Issue::getFileName, FilterType.INCLUDE);
            return this;
        }

        public IssueFilterBuilder setIncludeFileNameFilter(String ... pattern) {
            return this.setIncludeFileNameFilter(Arrays.asList(pattern));
        }

        public IssueFilterBuilder setExcludeFileNameFilter(Collection<String> pattern) {
            this.addNewFilter(pattern, Issue::getFileName, FilterType.EXCLUDE);
            return this;
        }

        public IssueFilterBuilder setExcludeFileNameFilter(String ... pattern) {
            return this.setExcludeFileNameFilter(Arrays.asList(pattern));
        }

        public IssueFilterBuilder setIncludePackageNameFilter(Collection<String> pattern) {
            this.addNewFilter(pattern, Issue::getPackageName, FilterType.INCLUDE);
            return this;
        }

        public IssueFilterBuilder setIncludePackageNameFilter(String ... pattern) {
            return this.setIncludePackageNameFilter(Arrays.asList(pattern));
        }

        public IssueFilterBuilder setExcludePackageNameFilter(Collection<String> pattern) {
            this.addNewFilter(pattern, Issue::getPackageName, FilterType.EXCLUDE);
            return this;
        }

        public IssueFilterBuilder setExcludePackageNameFilter(String ... pattern) {
            return this.setExcludePackageNameFilter(Arrays.asList(pattern));
        }

        public IssueFilterBuilder setIncludeModuleNameFilter(Collection<String> pattern) {
            this.addNewFilter(pattern, Issue::getModuleName, FilterType.INCLUDE);
            return this;
        }

        public IssueFilterBuilder setIncludeModuleNameFilter(String ... pattern) {
            return this.setIncludeModuleNameFilter(Arrays.asList(pattern));
        }

        public IssueFilterBuilder setExcludeModuleNameFilter(Collection<String> pattern) {
            this.addNewFilter(pattern, Issue::getModuleName, FilterType.EXCLUDE);
            return this;
        }

        public IssueFilterBuilder setExcludeModuleNameFilter(String ... pattern) {
            return this.setExcludeModuleNameFilter(Arrays.asList(pattern));
        }

        public IssueFilterBuilder setIncludeCategoryFilter(Collection<String> pattern) {
            this.addNewFilter(pattern, Issue::getCategory, FilterType.INCLUDE);
            return this;
        }

        public IssueFilterBuilder setIncludeCategoryFilter(String ... pattern) {
            return this.setIncludeCategoryFilter(Arrays.asList(pattern));
        }

        public IssueFilterBuilder setExcludeCategoryFilter(Collection<String> pattern) {
            this.addNewFilter(pattern, Issue::getCategory, FilterType.EXCLUDE);
            return this;
        }

        public IssueFilterBuilder setExcludeCategoryFilter(String ... pattern) {
            return this.setExcludeCategoryFilter(Arrays.asList(pattern));
        }

        public IssueFilterBuilder setIncludeTypeFilter(Collection<String> pattern) {
            this.addNewFilter(pattern, Issue::getType, FilterType.INCLUDE);
            return this;
        }

        public IssueFilterBuilder setIncludeTypeFilter(String ... pattern) {
            return this.setIncludeTypeFilter(Arrays.asList(pattern));
        }

        public IssueFilterBuilder setExcludeTypeFilter(Collection<String> pattern) {
            this.addNewFilter(pattern, Issue::getType, FilterType.EXCLUDE);
            return this;
        }

        public IssueFilterBuilder setExcludeTypeFilter(String ... pattern) {
            return this.setExcludeTypeFilter(Arrays.asList(pattern));
        }

        public IssueFilterBuilder setIncludeMessageFilter(Collection<String> pattern) {
            this.addMessageFilter(pattern, FilterType.INCLUDE);
            return this;
        }

        public IssueFilterBuilder setIncludeMessageFilter(String ... pattern) {
            return this.setIncludeMessageFilter(Arrays.asList(pattern));
        }

        public IssueFilterBuilder setExcludeMessageFilter(Collection<String> pattern) {
            this.addMessageFilter(pattern, FilterType.EXCLUDE);
            return this;
        }

        public IssueFilterBuilder setExcludeMessageFilter(String ... pattern) {
            return this.setExcludeMessageFilter(Arrays.asList(pattern));
        }

        private void addMessageFilter(Collection<String> pattern, FilterType filterType) {
            this.addNewFilter(pattern, issue -> String.format("%s%n%s", issue.getMessage(), issue.getDescription()), filterType);
        }

        static enum FilterType {
            INCLUDE,
            EXCLUDE;

        }
    }

    public static class StandardOutputPrinter
    implements IssuePrinter {
        private final PrintStream printStream;

        public StandardOutputPrinter() {
            this(System.out);
        }

        @VisibleForTesting
        StandardOutputPrinter(PrintStream printStream) {
            this.printStream = printStream;
        }

        @Override
        public void print(Issue issue) {
            this.printStream.println(issue.toString());
        }
    }

    public static interface IssuePrinter {
        public void print(Issue var1);
    }
}

