/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.LookaheadParser;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.LookaheadStream;
import java.util.Optional;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;

public class CMakeParser
extends LookaheadParser {
    private static final long serialVersionUID = 8149238560432255036L;
    private static final String CMAKE_WARNING_PATTERN = "^(?<prefix>.*?)CMake\\s+(?<type>Warning|Deprecation Warning|Error)(?:.*?(?<file>\\S+)){0,1}(?::(?<line>\\d+)\\s+(?<category>\\S+)){0,1}\\s*:";

    public CMakeParser() {
        super(CMAKE_WARNING_PATTERN);
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) {
        String category = StringUtils.strip((String)matcher.group("category"), (String)"()");
        int prefixLength = matcher.group("prefix").length();
        return builder.setFileName(matcher.group("file")).setLineStart(matcher.group("line")).setCategory(category).setMessage(this.readMessage(lookahead, prefixLength)).setSeverity(Severity.guessFromString(matcher.group("type"))).buildOptional();
    }

    private String readMessage(LookaheadStream lookahead, int prefixLength) {
        if (lookahead.hasNext()) {
            return StringUtils.substring((String)lookahead.next(), (int)prefixLength).trim();
        }
        return "";
    }
}

