/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.LookaheadParser;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.LookaheadStream;
import java.util.Optional;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;

public class ClangTidyParser
extends LookaheadParser {
    private static final long serialVersionUID = -3015592762345283182L;
    private static final String CLANG_TIDY_WARNING_PATTERN = "([^\\s]+):(\\d+):(\\d+): (warning|error): (.*?) \\[([^\\s]*?)\\]$";

    public ClangTidyParser() {
        super(CLANG_TIDY_WARNING_PATTERN);
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) {
        Severity priority = matcher.group(4).contains("error") ? Severity.WARNING_HIGH : Severity.WARNING_NORMAL;
        return builder.setFileName(matcher.group(1)).setSeverity(priority).setLineStart(matcher.group(2)).setColumnStart(matcher.group(3)).setType(StringUtils.capitalize((String)matcher.group(4))).setCategory(matcher.group(6)).setMessage(matcher.group(5)).buildOptional();
    }
}

