/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.LookaheadParser;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.util.LookaheadStream;
import java.util.ArrayList;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class EclipseParser
extends LookaheadParser {
    private static final long serialVersionUID = 425883472788422955L;
    private static final String ECLIPSE_FIRST_LINE_REGEXP = ".*\\d+\\.\\s*(?<severity>WARNING|ERROR|INFO) in (?<file>.*)\\s*\\(at line (?<line>\\d+)\\)";
    static final String WARNING = "WARNING";
    static final String ERROR = "ERROR";
    static final String INFO = "INFO";
    private static final String JAVADOC_PREFIX = "Javadoc:";
    private static final Pattern ANT_PREFIX = Pattern.compile("^(?:.*\\[.+\\])?\\s*(.*)");

    @Override
    public boolean accepts(ReaderFactory readerFactory) {
        return !this.isXmlFile(readerFactory);
    }

    public EclipseParser() {
        super(ECLIPSE_FIRST_LINE_REGEXP);
    }

    @Override
    protected boolean isLineInteresting(String line) {
        return line.contains(WARNING) || line.contains(ERROR) || line.contains(INFO);
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) {
        builder.guessSeverity(matcher.group("severity")).setFileName(matcher.group("file")).setLineStart(matcher.group("line"));
        ArrayList<String> context = new ArrayList<String>();
        while (!lookahead.hasNext("^.*----------.*$") && lookahead.hasNext()) {
            context.add(lookahead.next());
        }
        if (!context.isEmpty()) {
            EclipseParser.extractMessage(builder, (String)context.remove(context.size() - 1));
        }
        builder.setAdditionalProperties(Integer.valueOf(context.hashCode()));
        return builder.buildOptional();
    }

    static void extractMessage(IssueBuilder builder, String message) {
        Matcher messageMatcher = ANT_PREFIX.matcher(message);
        if (messageMatcher.matches()) {
            String msg = messageMatcher.group(1);
            builder.setMessage(msg);
            EclipseParser.extractCategory(builder, msg);
        }
    }

    static void extractCategory(IssueBuilder builder, String message) {
        if (StringUtils.startsWith((CharSequence)message, (CharSequence)JAVADOC_PREFIX)) {
            builder.setCategory("Javadoc");
        } else {
            builder.setCategory("Other");
        }
    }
}

