/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.LookaheadParser;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.LookaheadStream;
import java.util.Optional;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;

public class Gcc4LinkerParser
extends LookaheadParser {
    private static final long serialVersionUID = -2792019431810134790L;
    static final String WARNING_CATEGORY = "GCC4 Linker Error";
    private static final String LINKER_WARNING_PATTERN = "^(?:(.+?)(?:(?::(?:(\\d+):)? (undefined reference to .*))|(?::?\\(\\.\\w+\\+0x[0-9a-fA-F]+\\)): (?:(warning): )?(.*))|.*/ld(?:\\.exe)?: (?:(warning): )?(.*))$";

    public Gcc4LinkerParser() {
        super(LINKER_WARNING_PATTERN);
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) {
        String message;
        Severity priority;
        if (StringUtils.isNotBlank((CharSequence)matcher.group(7))) {
            priority = StringUtils.equalsIgnoreCase((CharSequence)matcher.group(6), (CharSequence)"warning") ? Severity.WARNING_NORMAL : Severity.WARNING_HIGH;
            message = matcher.group(7);
        } else if (StringUtils.isNotBlank((CharSequence)matcher.group(3))) {
            message = matcher.group(3);
            priority = Severity.WARNING_HIGH;
        } else {
            priority = StringUtils.equalsIgnoreCase((CharSequence)matcher.group(4), (CharSequence)"warning") ? Severity.WARNING_NORMAL : Severity.WARNING_HIGH;
            message = matcher.group(5);
            if (StringUtils.endsWith((CharSequence)message, (CharSequence)":")) {
                return Optional.empty();
            }
        }
        return builder.setFileName(StringUtils.defaultString((String)matcher.group(1))).setLineStart(matcher.group(2)).setCategory(WARNING_CATEGORY).setMessage(message).setSeverity(priority).buildOptional();
    }
}

