/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.LookaheadParser;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.LookaheadStream;
import java.util.Optional;
import java.util.regex.Matcher;

public class TnsdlParser
extends LookaheadParser {
    private static final long serialVersionUID = -7740789998865369930L;
    private static final String TNSDL_WARNING_PATTERN = "^tnsdl((.*)?):\\(.*\\) (.*) \\((.*)\\):(.*)$";

    public TnsdlParser() {
        super(TNSDL_WARNING_PATTERN);
    }

    @Override
    protected boolean isLineInteresting(String line) {
        return line.contains("tnsdl");
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) {
        return builder.setFileName(matcher.group(3)).setLineStart(matcher.group(4)).setMessage(matcher.group(5)).setSeverity(this.mapPriority(matcher)).buildOptional();
    }

    private Severity mapPriority(Matcher matcher) {
        if (matcher.group().contains("(E)")) {
            return Severity.WARNING_HIGH;
        }
        return Severity.WARNING_NORMAL;
    }
}

