/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser.checkstyle;

import edu.hm.hafner.analysis.SecureDigester;
import edu.hm.hafner.analysis.parser.checkstyle.Rule;
import edu.hm.hafner.analysis.parser.checkstyle.Topic;
import edu.hm.hafner.analysis.parser.checkstyle.TopicRule;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.digester3.Digester;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXException;

public class CheckStyleRules {
    private final Map<String, Rule> rulesByName = new HashMap<String, Rule>();

    public CheckStyleRules() {
        String[] ruleFiles;
        for (String ruleFile : ruleFiles = new String[]{"annotation", "blocks", "coding", "design", "filters", "header", "imports", "javadoc", "metrics", "misc", "modifier", "naming", "regexp", "reporting", "sizes", "whitespace"}) {
            try (InputStream inputStream = CheckStyleRules.class.getResourceAsStream("config_" + ruleFile + ".xml");){
                Digester digester = this.createDigester();
                ArrayList rules = new ArrayList();
                digester.push(rules);
                digester.parse(inputStream);
                for (Rule rule : rules) {
                    if (!StringUtils.isNotBlank((CharSequence)rule.getDescription())) continue;
                    this.rulesByName.put(rule.getName(), rule);
                }
            }
            catch (IOException | ParserConfigurationException | SAXException exception) {
                this.log(exception);
            }
        }
    }

    private void log(Throwable exception) {
        Logger.getLogger(CheckStyleRules.class.getName()).log(Level.SEVERE, "Can't initialize CheckStyle rules.", exception);
    }

    private Digester createDigester() throws ParserConfigurationException {
        SecureDigester digester = new SecureDigester(CheckStyleRules.class);
        String section = "*/section";
        digester.addObjectCreate(section, Rule.class);
        digester.addSetProperties(section);
        digester.addSetNext(section, "add");
        String subSection = "*/section/subsection";
        digester.addObjectCreate(subSection, Topic.class);
        digester.addSetProperties(subSection);
        digester.addSetNext(subSection, "setDescription");
        digester.addRule(subSection, (org.apache.commons.digester3.Rule)new TopicRule());
        return digester;
    }

    public Collection<Rule> getRules() {
        return Collections.unmodifiableCollection(this.rulesByName.values());
    }

    public Rule getRule(String name) {
        Rule rule = this.rulesByName.get(name);
        if (rule == null) {
            rule = this.rulesByName.get(StringUtils.removeEnd((String)name, (String)"Check"));
        }
        if (rule == null) {
            return new Rule(name);
        }
        return rule;
    }

    public String getDescription(String name) {
        return this.getRule(name).getDescription();
    }
}

