/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import com.google.errorprone.annotations.MustBeClosed;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.SecureXmlParserFactory;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.input.BOMInputStream;

public class FileReaderFactory
extends ReaderFactory {
    private final Path file;
    private final String fileName;
    @CheckForNull
    private Charset charset;
    private final boolean isCharsetUndetected;

    public FileReaderFactory(Path file, @CheckForNull Charset charset) {
        super(StandardCharsets.UTF_8);
        this.file = file;
        this.charset = charset;
        this.isCharsetUndetected = charset == null;
        this.fileName = file.toAbsolutePath().toString().replace('\\', '/');
    }

    public FileReaderFactory(Path file) {
        this(file, null);
    }

    @Override
    @MustBeClosed
    public Reader create() {
        try {
            if (this.isCharsetUndetected) {
                this.charset = this.detectCharset(Files.newInputStream(this.file, new OpenOption[0]));
            }
            InputStream inputStream = Files.newInputStream(this.file, new OpenOption[0]);
            return new InputStreamReader((InputStream)new BOMInputStream(inputStream), this.getCharset());
        }
        catch (FileNotFoundException | InvalidPathException exception) {
            throw new ParsingException(exception, "Can't find file '%s'", this.fileName);
        }
        catch (IOException | UncheckedIOException exception) {
            throw new ParsingException(exception, "Can't parse file '%s'", this.fileName);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CheckForNull
    private Charset detectCharset(InputStream inputStream) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.US_ASCII);){
            XMLStreamReader xmlStreamReader = new SecureXmlParserFactory().createXmlStreamReader(reader);
            String encodingTitle = xmlStreamReader.getCharacterEncodingScheme();
            if (encodingTitle == null) return null;
            Charset charset = Charset.forName(encodingTitle);
            return charset;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public Charset getCharset() {
        if (this.charset == null) {
            return super.getCharset();
        }
        return this.charset;
    }
}

