/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import edu.hm.hafner.analysis.FilteredLog;
import edu.hm.hafner.analysis.FullTextFingerprint;
import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.util.VisibleForTesting;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.nio.file.InvalidPathException;
import java.nio.file.NoSuchFileException;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class FingerprintGenerator {
    public void run(FullTextFingerprint algorithm, Report report, Charset charset) {
        FilteredLog log = new FilteredLog(report, "Can't create fingerprints for some files:");
        int sum = 0;
        for (Issue issue : report) {
            if (issue.hasFingerprint()) continue;
            sum += this.computeFingerprint(issue, algorithm, charset, log);
        }
        report.logInfo("-> created fingerprints for %d issues (skipped %d issues)", sum, report.size() - sum);
        log.logSummary();
    }

    private int computeFingerprint(Issue issue, FullTextFingerprint algorithm, Charset charset, FilteredLog log) {
        String absolutePath = issue.getAbsolutePath();
        try {
            if (issue.hasFileName()) {
                String digest = algorithm.compute(absolutePath, issue.getLineStart(), charset);
                issue.setFingerprint(digest);
                return 1;
            }
        }
        catch (FileNotFoundException | NoSuchFileException exception) {
            log.logError("- '%s' file not found", absolutePath);
        }
        catch (IOException | UncheckedIOException | InvalidPathException exception) {
            if (exception.getCause() instanceof MalformedInputException) {
                log.logError("- '%s', provided encoding '%s' seems to be wrong", absolutePath, charset);
            }
            log.logError("- '%s', IO exception has been thrown: %s", absolutePath, exception);
        }
        issue.setFingerprint(FingerprintGenerator.createDefaultFingerprint(issue));
        return 0;
    }

    @VisibleForTesting
    static String createDefaultFingerprint(Issue issue) {
        HashCodeBuilder builder = new HashCodeBuilder();
        return String.format("FALLBACK-%x", builder.append((Object)issue.getBaseName()).append((Object)issue.getType()).append((Object)issue.getCategory()).append((Object)issue.getSeverity()).append((Object)issue.getOrigin()).append(issue.getLineStart()).build());
    }
}

