/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import com.google.errorprone.annotations.MustBeClosed;
import edu.hm.hafner.analysis.SecureDigester;
import edu.hm.hafner.util.PathUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXException;

public class ModuleDetector {
    private static final String PLUS = ", ";
    private static final String BACK_SLASH = "\\";
    private static final String SLASH = "/";
    private static final String ALL_DIRECTORIES = "**/";
    private static final String BUNDLE_VENDOR = "Bundle-Vendor";
    private static final String BUNDLE_SYMBOLIC_NAME = "Bundle-SymbolicName";
    private static final String BUNDLE_NAME = "Bundle-Name";
    private static final String REPLACEMENT_CHAR = "%";
    static final String MAVEN_POM = "pom.xml";
    static final String ANT_PROJECT = "build.xml";
    static final String OSGI_BUNDLE = "META-INF/MANIFEST.MF";
    static final String BUILD_GRADLE = "build.gradle";
    static final String BUILD_GRADLE_KTS = "build.gradle.kts";
    static final String SETTINGS_GRADLE = "settings.gradle";
    static final String SETTINGS_GRADLE_KTS = "settings.gradle.kts";
    private static final String PATTERN = "**/pom.xml, **/build.xml, **/META-INF/MANIFEST.MF, **/build.gradle, **/build.gradle.kts, **/settings.gradle, **/settings.gradle.kts";
    static final String PLUGIN_PROPERTIES = "plugin.properties";
    static final String BUNDLE_PROPERTIES = "OSGI-INF/l10n/bundle.properties";
    private static final Pattern RE_GRADLE_SET_PROJECT_NAME = Pattern.compile("^\\s*rootProject\\.(name\\s*=|setName\\(?)\\s*['\"]([^'\"]*)['\"]\\)?");
    private final FileSystem factory;
    private final Map<String, String> fileNameToModuleName;
    private final List<String> prefixes;

    public ModuleDetector(Path workspace, FileSystem fileSystem) {
        this.factory = fileSystem;
        this.fileNameToModuleName = this.createFilesToModuleMapping(workspace);
        this.prefixes = new ArrayList<String>(this.fileNameToModuleName.keySet());
        Collections.sort(this.prefixes);
    }

    private Map<String, String> createFilesToModuleMapping(Path workspace) {
        HashMap<String, String> mapping = new HashMap<String, String>();
        String[] projects = this.find(workspace);
        this.collectAntProjects(mapping, projects);
        this.collectMavenProjects(mapping, projects);
        this.collectGradleProjects(mapping, projects);
        this.collectOsgiProjects(mapping, projects);
        return mapping;
    }

    private void collectAntProjects(Map<String, String> mapping, String ... projects) {
        for (String fileName : projects) {
            if (!fileName.endsWith(ANT_PROJECT)) continue;
            this.addMapping(mapping, fileName, ANT_PROJECT, this.parseBuildXml(fileName));
        }
    }

    private void collectMavenProjects(Map<String, String> mapping, String ... projects) {
        for (String fileName : projects) {
            if (!fileName.endsWith(MAVEN_POM)) continue;
            this.addMapping(mapping, fileName, MAVEN_POM, this.parsePom(fileName));
        }
    }

    private void collectGradleProjects(Map<String, String> mapping, String ... projects) {
        for (String fileName : projects) {
            if (fileName.endsWith(BUILD_GRADLE) || fileName.endsWith(BUILD_GRADLE_KTS)) {
                this.addMapping(mapping, fileName, BUILD_GRADLE, this.parseGradle(fileName));
                continue;
            }
            if (!fileName.endsWith(SETTINGS_GRADLE) && !fileName.endsWith(SETTINGS_GRADLE_KTS)) continue;
            this.addMapping(mapping, fileName, SETTINGS_GRADLE, this.parseGradleSettings(fileName));
        }
    }

    private void collectOsgiProjects(Map<String, String> mapping, String ... projects) {
        for (String fileName : projects) {
            if (!fileName.endsWith(OSGI_BUNDLE)) continue;
            this.addMapping(mapping, fileName, OSGI_BUNDLE, this.parseManifest(fileName));
        }
    }

    private void addMapping(Map<String, String> mapping, String fileName, String suffix, String moduleName) {
        if (StringUtils.isNotBlank((CharSequence)moduleName)) {
            mapping.put(StringUtils.substringBeforeLast((String)fileName, (String)suffix), moduleName);
        }
    }

    public String guessModuleName(String originalFileName) {
        String fullPath = originalFileName.replace('\\', '/');
        String guessedModule = "";
        for (String path : this.prefixes) {
            if (!fullPath.startsWith(path) || !this.fileNameToModuleName.containsKey(path)) continue;
            guessedModule = this.fileNameToModuleName.get(path);
        }
        return guessedModule;
    }

    private String[] find(Path path) {
        String[] relativeFileNames = this.factory.find(path, PATTERN);
        String[] absoluteFileNames = new String[relativeFileNames.length];
        for (int file = 0; file < absoluteFileNames.length; ++file) {
            String relativePath = this.normalizePath(relativeFileNames[file]);
            absoluteFileNames[file] = relativePath.startsWith(SLASH) ? relativePath : new PathUtil().getAbsolutePath(path) + SLASH + relativePath;
        }
        return absoluteFileNames;
    }

    private String normalizePath(String fileName) {
        return fileName.replace(BACK_SLASH, SLASH);
    }

    private String parseBuildXml(String buildXml) {
        String string;
        block8: {
            InputStream file = this.factory.open(buildXml);
            try {
                SecureDigester digester = new SecureDigester(ModuleDetector.class);
                digester.push(new StringBuilder());
                String xPath = "project";
                digester.addCallMethod(xPath, "append", 1);
                digester.addCallParam(xPath, 0, "name");
                StringBuilder result = (StringBuilder)digester.parse(file);
                string = result.toString();
                if (file == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (file != null) {
                        try {
                            file.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | InvalidPathException | SAXException exception) {
                    return "";
                }
            }
            file.close();
        }
        return string;
    }

    private String parseGradle(String buildScript) {
        String basePath = FilenameUtils.getPathNoEndSeparator((String)buildScript);
        String parentDirName = FilenameUtils.getName((String)basePath);
        return StringUtils.trimToEmpty((String)parentDirName);
    }

    private String parseGradleSettings(String settingsFile) {
        String name = null;
        try (InputStream input = this.factory.open(settingsFile);
             Scanner scan = new Scanner(input, "UTF-8");){
            while (scan.hasNextLine()) {
                String line = scan.findInLine(RE_GRADLE_SET_PROJECT_NAME);
                if (line != null) {
                    name = scan.match().group(2);
                    break;
                }
                scan.nextLine();
            }
        }
        catch (IOException | InvalidPathException exception) {
            // empty catch block
        }
        return (String)StringUtils.defaultIfBlank(name, (CharSequence)"");
    }

    private String parsePom(String pom) {
        String name = this.parsePomAttribute(pom, "name");
        return (String)StringUtils.defaultIfBlank((CharSequence)name, (CharSequence)this.parsePomAttribute(pom, "artifactId"));
    }

    private String parsePomAttribute(String pom, String tagName) {
        String string;
        block8: {
            InputStream file = this.factory.open(pom);
            try {
                SecureDigester digester = new SecureDigester(ModuleDetector.class);
                digester.push(new StringBuilder());
                digester.addCallMethod("project/" + tagName, "append", 0);
                StringBuilder result = (StringBuilder)digester.parse(file);
                string = result.toString();
                if (file == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (file != null) {
                        try {
                            file.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | InvalidPathException | SAXException exception) {
                    return "";
                }
            }
            file.close();
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String parseManifest(String manifestFile) {
        try (InputStream file = this.factory.open(manifestFile);){
            Manifest manifest = new Manifest(file);
            Attributes attributes = manifest.getMainAttributes();
            Properties properties = this.readProperties(StringUtils.substringBefore((String)manifestFile, (String)OSGI_BUNDLE));
            String name = this.getLocalizedValue(attributes, properties, BUNDLE_NAME);
            if (StringUtils.isNotBlank((CharSequence)name)) {
                String string2 = name;
                return string2;
            }
            String string = this.getSymbolicName(attributes, properties);
            return string;
        }
        catch (IOException | InvalidPathException exception) {
            return "";
        }
    }

    private String getLocalizedValue(Attributes attributes, Properties properties, String bundleName) {
        String value = attributes.getValue(bundleName);
        if (StringUtils.startsWith((CharSequence)StringUtils.trim((String)value), (CharSequence)REPLACEMENT_CHAR)) {
            return properties.getProperty(StringUtils.substringAfter((String)value, (String)REPLACEMENT_CHAR));
        }
        return value;
    }

    private Properties readProperties(String path) {
        Properties properties = new Properties();
        this.readProperties(path, properties, PLUGIN_PROPERTIES);
        this.readProperties(path, properties, BUNDLE_PROPERTIES);
        return properties;
    }

    private void readProperties(String path, Properties properties, String fileName) {
        try (InputStream file = this.factory.open(path + SLASH + fileName);){
            properties.load(file);
        }
        catch (IOException | InvalidPathException exception) {
            // empty catch block
        }
    }

    private String getSymbolicName(Attributes attributes, Properties properties) {
        String symbolicName = StringUtils.substringBefore((String)attributes.getValue(BUNDLE_SYMBOLIC_NAME), (String)";");
        if (StringUtils.isNotBlank((CharSequence)symbolicName)) {
            String vendor = this.getLocalizedValue(attributes, properties, BUNDLE_VENDOR);
            if (StringUtils.isNotBlank((CharSequence)vendor)) {
                return symbolicName + " (" + vendor + ")";
            }
            return symbolicName;
        }
        return "";
    }

    public static interface FileSystem {
        public String[] find(Path var1, String var2);

        @MustBeClosed
        public InputStream open(String var1) throws IOException, InvalidPathException;
    }
}

