/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import edu.hm.hafner.analysis.ParsingException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import org.apache.commons.io.input.ReaderInputStream;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public class SecureXmlParserFactory {
    private static final String[] ENABLED_PROPERTIES = new String[]{"http://javax.xml.XMLConstants/feature/secure-processing"};
    private static final String[] DISABLED_PROPERTIES = new String[]{"http://xml.org/sax/features/external-general-entities", "http://xml.org/sax/features/external-parameter-entities", "http://xml.org/sax/features/resolve-dtd-uris", "http://xml.org/sax/features/use-entity-resolver2", "http://apache.org/xml/features/dom/create-entity-ref-nodes", "http://apache.org/xml/features/nonvalidating/load-dtd-grammar", "http://apache.org/xml/features/nonvalidating/load-external-dtd"};
    private static final String[] DISABLED_ATTRIBUTES = new String[]{"http://javax.xml.XMLConstants/property/accessExternalDTD", "http://javax.xml.XMLConstants/property/accessExternalSchema", "http://javax.xml.XMLConstants/property/accessExternalStylesheet"};
    private static final String CLEAR_ATTRIBUTE = "";
    private static final String SUPPORTING_EXTERNAL_ENTITIES = "javax.xml.stream.isSupportingExternalEntities";

    public DocumentBuilder createDocumentBuilder() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setXIncludeAware(false);
            factory.setExpandEntityReferences(false);
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            this.setFeatures(factory);
            this.clearAttributes(factory);
            return factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException exception) {
            throw new IllegalArgumentException("Can't create instance of DocumentBuilder", exception);
        }
    }

    private void setFeatures(DocumentBuilderFactory factory) {
        for (String enabledProperty : ENABLED_PROPERTIES) {
            this.setFeature(factory, enabledProperty, true);
        }
        for (String disabledProperty : DISABLED_PROPERTIES) {
            this.setFeature(factory, disabledProperty, false);
        }
    }

    private void setFeature(DocumentBuilderFactory factory, String enabledProperty, boolean value) {
        try {
            factory.setFeature(enabledProperty, value);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
    }

    private void clearAttributes(DocumentBuilderFactory factory) {
        for (String securityAttribute : DISABLED_ATTRIBUTES) {
            try {
                factory.setAttribute(securityAttribute, CLEAR_ATTRIBUTE);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private void clearAttributes(TransformerFactory transformerFactory) {
        for (String securityAttribute : DISABLED_ATTRIBUTES) {
            try {
                transformerFactory.setAttribute(securityAttribute, CLEAR_ATTRIBUTE);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public SAXParser createSaxParser() {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            this.configureSaxParserFactory(factory);
            SAXParser parser = factory.newSAXParser();
            this.secureParser(parser);
            return parser;
        }
        catch (ParserConfigurationException | SAXException exception) {
            throw new IllegalArgumentException("Can't create instance of SAXParser", exception);
        }
    }

    private void secureParser(SAXParser parser) {
        for (String securityAttribute : DISABLED_ATTRIBUTES) {
            try {
                parser.setProperty(securityAttribute, CLEAR_ATTRIBUTE);
            }
            catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
                // empty catch block
            }
        }
    }

    public void configureSaxParserFactory(SAXParserFactory factory) {
        factory.setValidating(false);
        factory.setXIncludeAware(false);
        for (String enabledProperty : ENABLED_PROPERTIES) {
            try {
                factory.setFeature(enabledProperty, true);
            }
            catch (ParserConfigurationException | SAXException exception) {
                // empty catch block
            }
        }
        for (String disabledProperty : DISABLED_PROPERTIES) {
            try {
                factory.setFeature(disabledProperty, false);
            }
            catch (ParserConfigurationException | SAXException exception) {
                // empty catch block
            }
        }
    }

    public XMLStreamReader createXmlStreamReader(Reader reader) {
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            factory.setProperty("javax.xml.stream.supportDTD", false);
            factory.setProperty(SUPPORTING_EXTERNAL_ENTITIES, false);
            return factory.createXMLStreamReader(reader);
        }
        catch (XMLStreamException exception) {
            throw new IllegalArgumentException("Can't create instance of XMLStreamReader", exception);
        }
    }

    @SuppressFBWarnings(value={"XXE_SAXPARSER"}, justification="The parser is secured in the called method")
    public void parse(Reader reader, Charset charset, DefaultHandler handler) {
        try {
            this.createSaxParser().parse(this.createInputSource(reader, charset), handler);
        }
        catch (IOException | SAXException exception) {
            throw new ParsingException(exception);
        }
    }

    @SuppressFBWarnings(value={"XXE_DOCUMENT"}, justification="The parser is secured in the called method")
    public Document readDocument(Reader reader, Charset charset) {
        try {
            return this.createDocumentBuilder().parse(this.createInputSource(reader, charset));
        }
        catch (IOException | SAXException exception) {
            throw new ParsingException(exception);
        }
    }

    private InputSource createInputSource(Reader reader, Charset charset) {
        return new InputSource((InputStream)new ReaderInputStream(reader, charset));
    }

    @SuppressFBWarnings(value={"XXE_DTD_TRANSFORM_FACTORY", "XXE_XSLT_TRANSFORM_FACTORY"}, justification="The transformer is secured in the called method")
    public Transformer createTransformer() {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            this.clearAttributes(transformerFactory);
            return transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException exception) {
            throw new ParsingException(exception);
        }
    }
}

