/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.LookaheadParser;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractMavenLogParser
extends LookaheadParser {
    private static final long serialVersionUID = -3768790896172545192L;
    private static final Pattern MAVEN_PLUGIN_START = Pattern.compile("\\[INFO\\] --- (?<id>\\S+):(?<version>\\S+):(?<goal>\\S+)\\s.*");
    private static final Pattern MAVEN_MODULE_START = Pattern.compile("-+< (?<id>\\S+) >-+");
    static final String MAVEN_COMPILER_PLUGIN = "maven-compiler-plugin";
    private String goal = "";
    private String module = "";

    protected AbstractMavenLogParser(String pattern) {
        super(pattern);
    }

    @Override
    protected void preprocessLine(String line) {
        Matcher moduleMatcher;
        Matcher goalMatcher = MAVEN_PLUGIN_START.matcher(line);
        if (goalMatcher.find()) {
            this.goal = String.format("%s:%s", goalMatcher.group("id"), goalMatcher.group("goal"));
        }
        if ((moduleMatcher = MAVEN_MODULE_START.matcher(line)).find()) {
            this.module = moduleMatcher.group("id");
        }
    }

    protected String getModule() {
        return this.module;
    }

    protected String getGoal() {
        return this.goal;
    }

    boolean hasGoalOrModule() {
        return StringUtils.isNotBlank((CharSequence)this.goal) || StringUtils.isNotBlank((CharSequence)this.module);
    }
}

