/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class EmbeddedEngineerParser
extends IssueParser {
    private static final long serialVersionUID = -1251248150731418714L;
    private static final Pattern HEADER_PATTERN = Pattern.compile("^Starting code generation for\\s(?<file>.*\\))");
    private static final Pattern WARNING_PATTERN = Pattern.compile("^(Warning:)\\s(?<description>[^']*)'(?<module>[^']*)'\\s(?<details>\\(?[^(]*)\\((?<serial>[^)]*)\\)");

    @Override
    public Report parse(ReaderFactory reader) throws ParsingException {
        Report report;
        block8: {
            Stream<String> lines = reader.readStream();
            try {
                report = this.parse(lines);
                if (lines == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (UncheckedIOException e) {
                    throw new ParsingException(e);
                }
            }
            lines.close();
        }
        return report;
    }

    private Report parse(Stream<String> lines) {
        try (IssueBuilder builder = new IssueBuilder();){
            Iterator<String> lineIterator = lines.iterator();
            String file = this.parseFileName(lineIterator);
            Report report = new Report();
            while (lineIterator.hasNext()) {
                String line = lineIterator.next();
                Matcher matcher = WARNING_PATTERN.matcher(line);
                if (!matcher.matches()) continue;
                String category = this.setCategory(line);
                Severity priority = this.mapPriority(line);
                String description = String.format("%s'%s' %s(%s)", matcher.group("description"), matcher.group("module"), matcher.group("details"), matcher.group("serial"));
                builder.setDescription(description);
                builder.setCategory(category);
                builder.setFileName(file);
                builder.setModuleName(matcher.group("module"));
                builder.setSeverity(priority);
                report.add(builder.build());
            }
            Report report2 = report;
            return report2;
        }
    }

    private String parseFileName(Iterator<String> lineIterator) {
        while (lineIterator.hasNext()) {
            String line = lineIterator.next();
            Matcher matcher = HEADER_PATTERN.matcher(line);
            if (!matcher.matches()) continue;
            return matcher.group("file");
        }
        return "";
    }

    private String setCategory(String line) {
        if (line.contains("Complex type")) {
            return "Complex type definition without referenced element";
        }
        if (line.contains("skipped")) {
            return "Code generation skipped";
        }
        if (line.contains("failed")) {
            return "Code generation failed";
        }
        return "No Category";
    }

    private Severity mapPriority(String line) {
        if (line.contains("Complex type")) {
            return Severity.WARNING_NORMAL;
        }
        if (line.contains("skipped")) {
            return Severity.WARNING_NORMAL;
        }
        if (line.contains("failed")) {
            return Severity.WARNING_HIGH;
        }
        return Severity.WARNING_NORMAL;
    }
}

