/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.parser.JsonIssueParser;
import java.io.IOException;
import java.io.Reader;
import java.util.Optional;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class FlowParser
extends JsonIssueParser {
    private static final long serialVersionUID = 2379734578953758L;
    private static final String FLOW_PASSED = "passed";
    private static final String ISSUES = "errors";
    private static final String FLOW_VERSION = "flowVersion";
    private static final String ISSUE_MESSAGE = "message";
    private static final String ISSUE_LEVEL = "level";
    private static final String ISSUE_KIND = "kind";
    private static final String MESSAGE_PATH = "path";
    private static final String MESSAGE_DESCR = "descr";
    private static final String MESSAGE_LINE_START = "line";
    private static final String MESSAGE_LINE_END = "endLine";
    private static final String MESSAGE_COLUMN_START = "start";
    private static final String MESSAGE_COLUMN_END = "end";
    private static final String LEVEL_ERROR = "error";
    private static final String LEVEL_WARNING = "warning";

    @Override
    public boolean accepts(ReaderFactory readerFactory) {
        boolean bl;
        block8: {
            Reader reader = readerFactory.create();
            try {
                Object value = new JSONTokener(reader).nextValue();
                boolean bl2 = bl = value instanceof JSONObject && ((JSONObject)value).has(FLOW_VERSION);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | JSONException ignored) {
                    return false;
                }
            }
            reader.close();
        }
        return bl;
    }

    @Override
    protected void parseJsonObject(Report report, JSONObject jsonReport, IssueBuilder issueBuilder) {
        if (!jsonReport.getBoolean(FLOW_PASSED)) {
            this.extractIssues(jsonReport.optJSONArray(ISSUES), report, issueBuilder);
        }
    }

    private Report extractIssues(JSONArray elements, Report report, IssueBuilder issueBuilder) {
        for (Object object : elements) {
            if (!(object instanceof JSONObject)) continue;
            JSONObject issue = (JSONObject)object;
            this.findFirstMessage(issue).ifPresent(jsonObject -> report.add(this.createIssueFromJsonObject(issue, (JSONObject)jsonObject, issueBuilder)));
        }
        return report;
    }

    private Optional<JSONObject> findFirstMessage(JSONObject issue) {
        JSONArray message = issue.optJSONArray(ISSUE_MESSAGE);
        if (message == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(message.optJSONObject(0));
    }

    private Issue createIssueFromJsonObject(JSONObject issue, JSONObject message, IssueBuilder issueBuilder) {
        return issueBuilder.setFileName(this.parseFileNameFromMessage(message)).setType(this.parseType(issue)).setSeverity(this.parseSeverity(issue)).setLineStart(this.parseLocFromMessage(message, MESSAGE_LINE_START)).setLineEnd(this.parseLocFromMessage(message, MESSAGE_LINE_END)).setColumnStart(this.parseLocFromMessage(message, MESSAGE_COLUMN_START)).setColumnEnd(this.parseLocFromMessage(message, MESSAGE_COLUMN_END)).setMessage(this.parseMessageFromMessage(message)).buildAndClean();
    }

    private Severity parseSeverity(JSONObject issue) {
        String level = issue.optString(ISSUE_LEVEL);
        if (LEVEL_ERROR.equals(level)) {
            return Severity.ERROR;
        }
        if (LEVEL_WARNING.equals(level)) {
            return Severity.WARNING_NORMAL;
        }
        return Severity.WARNING_NORMAL;
    }

    private String parseType(JSONObject issue) {
        return issue.optString(ISSUE_KIND);
    }

    private String parseFileNameFromMessage(JSONObject message) {
        return message.optString(MESSAGE_PATH);
    }

    private String parseMessageFromMessage(JSONObject message) {
        return message.optString(MESSAGE_DESCR);
    }

    private Integer parseLocFromMessage(JSONObject message, String key) {
        return message.optInt(key);
    }
}

