/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Categories;
import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.parser.AbstractMavenLogParser;
import edu.hm.hafner.util.LookaheadStream;
import java.util.Optional;
import java.util.regex.Matcher;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;

public class JavacParser
extends AbstractMavenLogParser {
    private static final long serialVersionUID = 7199325311690082782L;
    private static final String ERRORPRONE_URL_PATTERN = "\\s+\\(see https?://\\S+\\s*\\)";
    private static final String JAVAC_WARNING_PATTERN = "^(?:\\S+\\s+)?(?:(?:\\[(WARNING|ERROR)\\]|w:|e:)\\s+)([^\\[\\(]*):\\s*[\\[\\(](\\d+)[.,;]*\\s?(\\d+)?[\\]\\)]\\s*:?(?:\\[(\\w+)\\])?\\s*(.*)$";
    private static final String SEVERITY_ERROR = "ERROR";
    private static final String SEVERITY_ERROR_SHORT = "e:";
    private static final String DEFAULT_GOAL = "javac";

    public JavacParser() {
        super(JAVAC_WARNING_PATTERN);
    }

    @Override
    protected boolean isLineInteresting(String line) {
        return line.contains("[") || line.contains("w:") || line.contains(SEVERITY_ERROR_SHORT);
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) throws ParsingException {
        if (lookahead.hasNext(ERRORPRONE_URL_PATTERN)) {
            return Optional.empty();
        }
        String type = matcher.group(1);
        if (SEVERITY_ERROR.equals(type) || SEVERITY_ERROR_SHORT.equals(type)) {
            builder.setSeverity(Severity.ERROR);
        } else {
            builder.setSeverity(Severity.WARNING_NORMAL);
        }
        String message = matcher.group(6);
        String category = Categories.guessCategoryIfEmpty(matcher.group(5), message);
        return builder.setFileName(RegExUtils.replaceAll((String)matcher.group(2), (String)"^/([a-zA-Z]):", (String)"$1:")).setLineStart(matcher.group(3)).setType(StringUtils.defaultString((String)this.getGoal(), (String)DEFAULT_GOAL)).setColumnStart(matcher.group(4)).setCategory(category).setMessage(message).buildOptional();
    }
}

