/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import java.io.IOException;
import java.io.Reader;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public abstract class JsonIssueParser
extends IssueParser {
    private static final long serialVersionUID = -4062256623915009878L;

    @Override
    public Report parse(ReaderFactory readerFactory) throws ParsingException {
        Report report;
        block15: {
            report = new Report();
            try (Reader reader = readerFactory.create();
                 IssueBuilder issueBuilder = new IssueBuilder();){
                Object parsedValue = new JSONTokener(reader).nextValue();
                if (parsedValue instanceof JSONObject) {
                    JSONObject jsonReport = (JSONObject)parsedValue;
                    this.parseJsonObject(report, jsonReport, issueBuilder);
                    break block15;
                }
                if (parsedValue instanceof JSONArray) {
                    JSONArray jsonReport = (JSONArray)parsedValue;
                    this.parseJsonArray(report, jsonReport, issueBuilder);
                    break block15;
                }
                throw new ParsingException("Cannot process parsed JSON object '%s'", parsedValue);
            }
            catch (IOException | ClassCastException | JSONException e) {
                throw new ParsingException(e);
            }
        }
        return report;
    }

    @Override
    public boolean accepts(ReaderFactory readerFactory) {
        return readerFactory.getFileName().endsWith(".json");
    }

    protected void parseJsonObject(Report report, JSONObject jsonReport, IssueBuilder issueBuilder) {
    }

    protected void parseJsonArray(Report report, JSONArray jsonReport, IssueBuilder issueBuilder) {
    }
}

