/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.parser.AbstractMavenLogParser;
import edu.hm.hafner.util.LookaheadStream;
import j2html.TagCreator;
import j2html.tags.DomContent;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;

public class MavenConsoleParser
extends AbstractMavenLogParser {
    private static final long serialVersionUID = 1737791073711198075L;
    private static final String WARNING = "WARNING";
    private static final String ERROR = "ERROR";
    protected static final Pattern MAVEN_PLUGIN_START = Pattern.compile("\\[INFO\\] --- (?<id>\\S+):(?<version>\\S+):(?<goal>\\S+)\\s.*");
    private static final Pattern MAVEN_MODULE_START = Pattern.compile("-+< (?<id>\\S+) >-+");
    private static final String PATTERN = "^(?<timestamp>.*\\s|)\\[(?<severity>WARNING|ERROR)\\]\\s*(?<message>.*)$";
    private String goal = "";
    private String module = "";

    public MavenConsoleParser() {
        super(PATTERN);
    }

    @Override
    protected boolean isLineInteresting(String line) {
        Matcher moduleMatcher;
        Matcher goalMatcher = MAVEN_PLUGIN_START.matcher(line);
        if (goalMatcher.find()) {
            this.goal = String.format("%s:%s", goalMatcher.group("id"), goalMatcher.group("goal"));
        }
        if ((moduleMatcher = MAVEN_MODULE_START.matcher(line)).find()) {
            this.module = moduleMatcher.group("id");
        }
        return this.isValidGoal() && (line.contains(WARNING) || line.contains(ERROR));
    }

    private boolean isValidGoal() {
        return !this.goal.contains("maven-compiler-plugin") && !this.goal.contains("maven-javadoc-plugin");
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) throws ParsingException {
        String severity = matcher.group("severity");
        builder.setLineStart(lookahead.getLine()).guessSeverity(severity);
        StringBuilder message = new StringBuilder(matcher.group("message"));
        if (this.goal.startsWith("maven-enforcer-plugin")) {
            String timestamp = matcher.group("timestamp");
            int length = StringUtils.length((CharSequence)timestamp);
            String continuation = "^(?:.*\\s|)\\[(INFO|WARNING|ERROR)";
            while (!lookahead.hasNext(continuation)) {
                message.append('\n');
                message.append(StringUtils.substring((String)lookahead.next(), (int)length));
            }
        } else {
            String continuation = "^(?:.*\\s\\s|)\\[" + severity + "\\] ";
            while (lookahead.hasNext(continuation)) {
                message.append('\n');
                message.append(RegExUtils.removeFirst((String)lookahead.next(), (String)continuation));
            }
            if (message.lastIndexOf("Unable to locate Source XRef to link to") >= 0) {
                builder.setSeverity(Severity.WARNING_LOW);
            }
            if (StringUtils.isBlank((CharSequence)message.toString())) {
                return Optional.empty();
            }
        }
        return builder.setDescription(TagCreator.pre().with((DomContent)TagCreator.code().withText(message.toString())).render()).setType(this.goal).setModuleName(this.module).setLineEnd(lookahead.getLine()).setFileName(lookahead.getFileName()).buildOptional();
    }
}

