/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.IntegerParser;
import java.io.Serializable;
import java.util.Iterator;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class PolyspaceParser
extends IssueParser {
    private static final long serialVersionUID = -1251248150596418714L;
    static final int SEVERITY_INDEX = 10;
    static final int COLOR_INDEX = 3;
    static final int FAMILY_INDEX = 1;

    @Override
    public Report parse(ReaderFactory reader) throws ParsingException {
        try (Stream<String> lines = reader.readStream();){
            Report report = this.parse(lines);
            return report;
        }
    }

    private Report parse(Stream<String> lines) {
        try (IssueBuilder builder = new IssueBuilder();){
            Report report = new Report();
            Iterator<String> lineIterator = lines.iterator();
            int offset = this.detectLineOffset(lineIterator);
            while (lineIterator.hasNext()) {
                String line = lineIterator.next();
                String[] attributes = line.split("\\t", 15 + offset);
                if (!StringUtils.containsAnyIgnoreCase((CharSequence)attributes[9], (CharSequence[])new CharSequence[]{"Unreviewed", "To investigate", "To fix", "Other"})) continue;
                builder.setFileName(attributes[8]);
                builder.setCategory(attributes[2]);
                builder.setDescription(attributes[1]);
                builder.setMessage("Check: " + attributes[5] + " " + attributes[6]);
                builder.setModuleName(attributes[7]);
                builder.setColumnStart(IntegerParser.parseInt(attributes[14 + offset]));
                builder.setLineStart(IntegerParser.parseInt(attributes[13 + offset]));
                builder.setSeverity(this.mapPriority(attributes));
                builder.setAdditionalProperties((Serializable)((Object)attributes[0]));
                report.add(builder.build());
            }
            Report report2 = report;
            return report2;
        }
    }

    private int detectLineOffset(Iterator<String> lineIterator) {
        if (this.readHeader(lineIterator).contains("CWE ID")) {
            return 1;
        }
        return 0;
    }

    private String readHeader(Iterator<String> lineIterator) {
        if (lineIterator.hasNext()) {
            return lineIterator.next();
        }
        return "";
    }

    private Severity mapPriority(String[] attributes) {
        if (PolyspaceParser.equalsIgnoreCase(attributes[10], "Unset")) {
            if (PolyspaceParser.equalsIgnoreCase(attributes[1], "Defect") || PolyspaceParser.equalsIgnoreCase(attributes[3], "Red")) {
                return Severity.WARNING_HIGH;
            }
            if (StringUtils.containsAnyIgnoreCase((CharSequence)attributes[3], (CharSequence[])new CharSequence[]{"Orange", "Not Applicable"})) {
                return Severity.WARNING_NORMAL;
            }
            if (StringUtils.containsAnyIgnoreCase((CharSequence)attributes[3], (CharSequence[])new CharSequence[]{"Gray", "Green"})) {
                return Severity.WARNING_LOW;
            }
        } else {
            if (PolyspaceParser.equalsIgnoreCase(attributes[10], "High")) {
                return Severity.WARNING_HIGH;
            }
            if (PolyspaceParser.equalsIgnoreCase(attributes[10], "Medium")) {
                return Severity.WARNING_NORMAL;
            }
            if (PolyspaceParser.equalsIgnoreCase(attributes[10], "Low")) {
                return Severity.WARNING_LOW;
            }
        }
        return Severity.WARNING_NORMAL;
    }
}

