/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Categories;
import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.ParsingCanceledException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.text.CaseUtils;

public class RfLintParser
extends IssueParser {
    private static final long serialVersionUID = -7903991158616386226L;
    private String fileName = "";
    private static final Pattern WARNING_PATTERN = Pattern.compile("(?<severity>[WEI]): (?<lineNumber>\\d+), (?<columnNumber>\\d+): (?<message>.*) \\((?<ruleName>.*)\\)");
    private static final Pattern FILE_PATTERN = Pattern.compile("\\+\\s(?<filename>.*)");

    @Override
    public Report parse(ReaderFactory readerFactory) {
        try (Stream<String> lines = readerFactory.readStream();){
            IssueBuilder builder = new IssueBuilder();
            try {
                Report warnings = new Report();
                lines.forEach(line -> this.parseLine(builder, warnings, (String)line));
                Report report = warnings;
                builder.close();
                return report;
            }
            catch (Throwable throwable) {
                try {
                    builder.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private void parseLine(IssueBuilder builder, Report warnings, String line) {
        Matcher matcher;
        Matcher fileMatcher = FILE_PATTERN.matcher(line);
        if (fileMatcher.find()) {
            this.fileName = fileMatcher.group(1);
        }
        if ((matcher = WARNING_PATTERN.matcher(line)).find()) {
            warnings.add(this.createIssue(matcher, builder));
        }
        if (Thread.interrupted()) {
            throw new ParsingCanceledException();
        }
    }

    private Issue createIssue(Matcher matcher, IssueBuilder builder) {
        String message = matcher.group("message");
        String severityStr = Categories.guessCategoryIfEmpty(matcher.group("severity"), message);
        Severity priority = RfLintSeverity.fromCharacter(severityStr.charAt(0)).getSeverityLevel();
        String ruleName = matcher.group("ruleName");
        RfLintCategory category = RfLintRuleName.fromName(ruleName).getCategory();
        return builder.setFileName(this.fileName).setPackageName(Objects.toString(Paths.get(this.fileName, new String[0]).getParent())).setLineStart(matcher.group("lineNumber")).setColumnStart(matcher.group("columnNumber")).setCategory(category.getName()).setType(ruleName).setMessage(message).setSeverity(priority).buildAndClean();
    }

    private static enum RfLintSeverity {
        ERROR(Severity.WARNING_HIGH),
        E(ERROR),
        WARNING(Severity.WARNING_NORMAL),
        W(WARNING),
        IGNORE(Severity.WARNING_LOW),
        I(IGNORE);

        private final Severity severityLevel;

        private RfLintSeverity(Severity level) {
            this.severityLevel = level;
        }

        private RfLintSeverity(RfLintSeverity e) {
            this(e.severityLevel);
        }

        public Severity getSeverityLevel() {
            return this.severityLevel;
        }

        public static RfLintSeverity fromCharacter(char violationSeverity) {
            if (EnumUtils.isValidEnum(RfLintSeverity.class, (String)String.valueOf(violationSeverity))) {
                return RfLintSeverity.valueOf(String.valueOf(violationSeverity));
            }
            return WARNING;
        }
    }

    private static enum RfLintRuleName {
        DUPLICATE_KEYWORD_NAMES(RfLintCategory.SUITE),
        DUPLICATE_TEST_NAMES(RfLintCategory.SUITE),
        FILE_TOO_LONG(RfLintCategory.OTHER),
        INVALID_TABLE(RfLintCategory.SUITE),
        LINE_TOO_LONG(RfLintCategory.OTHER),
        PERIOD_IN_SUITE_NAME(RfLintCategory.SUITE),
        PERIOD_IN_TEST_NAME(RfLintCategory.TEST_CASE),
        REQUIRE_KEYWORD_DOCUMENTATION(RfLintCategory.KEYWORD),
        REQUIRE_SUITE_DOCUMENTATION(RfLintCategory.SUITE),
        REQUIRE_TEST_DOCUMENTATION(RfLintCategory.SUITE),
        TAG_WITH_SPACES(RfLintCategory.TEST_CASE),
        TOO_FEW_KEYWORD_STEPS(RfLintCategory.KEYWORD),
        TOO_MANY_TEST_CASES(RfLintCategory.SUITE),
        TOO_FEW_TEST_STEPS(RfLintCategory.TEST_CASE),
        TOO_MANY_TEST_STEPS(RfLintCategory.TEST_CASE),
        TRAILING_BLANK_LINES(RfLintCategory.OTHER),
        TRAILING_WHITESPACE(RfLintCategory.OTHER),
        UNKNOWN(RfLintCategory.CUSTOM);

        private static final boolean CAPITALIZE_FIRST_LETTER = true;
        private final RfLintCategory category;

        private RfLintRuleName(RfLintCategory category) {
            this.category = category;
        }

        public RfLintCategory getCategory() {
            return this.category;
        }

        public static RfLintRuleName fromName(String name) {
            for (RfLintRuleName rule : RfLintRuleName.values()) {
                if (!CaseUtils.toCamelCase((String)rule.name(), (boolean)true, (char[])new char[]{'_'}).equals(name)) continue;
                return rule;
            }
            return UNKNOWN;
        }
    }

    private static enum RfLintCategory {
        SUITE("Suite"),
        KEYWORD("Keyword"),
        TEST_CASE("Test Case"),
        OTHER("Other"),
        CUSTOM("Custom");

        private final String name;

        private RfLintCategory(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

