/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser.pmd;

import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetLoader;
import org.apache.commons.lang3.StringUtils;

public class PmdMessages {
    private final Map<String, RuleSet> rules = new HashMap<String, RuleSet>();

    public PmdMessages() {
        RuleSetLoader loader = new RuleSetLoader();
        List ruleSets = loader.getStandardRuleSets();
        for (RuleSet ruleSet : ruleSets) {
            this.rules.put(ruleSet.getName(), ruleSet);
        }
        if (this.rules.isEmpty()) {
            throw new IllegalStateException("No rule sets found");
        }
    }

    public int size() {
        return this.rules.size();
    }

    public String getMessage(String ruleSetName, String ruleName) {
        RuleSet ruleSet;
        Rule rule;
        if (this.rules.containsKey(ruleSetName) && (rule = (ruleSet = this.rules.get(ruleSetName)).getRuleByName(ruleName)) != null) {
            return this.createMessage(rule);
        }
        return "";
    }

    private String createMessage(Rule rule) {
        StringBuilder message = new StringBuilder(rule.getDescription());
        List examples = rule.getExamples();
        if (!examples.isEmpty()) {
            message.append(TagCreator.pre().with((DomContent)TagCreator.code((String)((String)examples.get(0)))).renderFormatted());
        }
        if (StringUtils.isNotBlank((CharSequence)rule.getExternalInfoUrl())) {
            message.append(((ContainerTag)TagCreator.a().withHref(rule.getExternalInfoUrl())).withText("See PMD documentation.").renderFormatted());
        }
        return message.toString();
    }
}

