/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import edu.hm.hafner.analysis.ModuleDetector;
import edu.hm.hafner.util.PathUtil;
import edu.hm.hafner.util.ResourceTest;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

abstract class AbstractModuleDetectorTest
extends ResourceTest {
    static final Path ROOT = Paths.get(File.pathSeparatorChar == ';' ? "C:\\Windows" : "/tmp", new String[0]);
    static final Path ROOT_ABSOLUTE = Paths.get(File.pathSeparatorChar == ';' ? "C:\\" : "/", new String[0]);
    static final String PREFIX = new PathUtil().getAbsolutePath(ROOT) + "/";
    static final String MANIFEST = "MANIFEST.MF";
    static final String MANIFEST_NAME = "MANIFEST-NAME.MF";

    AbstractModuleDetectorTest() {
    }

    @Test
    void shouldIgnoreExceptionsDuringParsing() {
        ModuleDetector.FileSystem fileSystem = this.createFileSystemStub(stub -> {
            Mockito.when((Object)stub.find((Path)Mockito.any(), Mockito.anyString())).thenReturn((Object)new String[]{this.getPathPrefix() + this.getProjectFileName()});
            Mockito.when((Object)stub.open(Mockito.anyString())).thenThrow(new Throwable[]{new FileNotFoundException("File not found")});
        });
        ModuleDetector detector = new ModuleDetector(ROOT, fileSystem);
        Assertions.assertThat((String)detector.guessModuleName(PREFIX + this.getFileName())).isEqualTo("");
    }

    abstract String getPathPrefix();

    abstract String getFileName();

    abstract String getProjectFileName();

    protected ModuleDetector.FileSystem createFileSystemStub(Stub stub) {
        try {
            ModuleDetector.FileSystem fileSystem = (ModuleDetector.FileSystem)Mockito.mock(ModuleDetector.FileSystem.class);
            stub.apply(fileSystem);
            return fileSystem;
        }
        catch (IOException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    protected InputStream read(String fileName) {
        return this.asInputStream(fileName);
    }

    @FunctionalInterface
    protected static interface Stub {
        public void apply(ModuleDetector.FileSystem var1) throws IOException;
    }
}

