/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import com.google.errorprone.annotations.FormatMethod;
import edu.hm.hafner.analysis.Report;
import java.util.Arrays;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class FilteredLog {
    private static final String SKIPPED_MESSAGE = "  ... skipped logging of %d additional errors ...";
    private static final int DEFAULT_MAX_LINES = 20;
    private final Report delegate;
    private final String title;
    private final int maxLines;
    private int lines = 0;

    public FilteredLog(Report report, String title) {
        this(report, title, 20);
    }

    public FilteredLog(Report report, String title, int maxLines) {
        this.delegate = report;
        this.title = title;
        this.maxLines = maxLines;
    }

    @FormatMethod
    public void logInfo(String format, Object ... args) {
        this.delegate.logInfo(format, args);
    }

    @FormatMethod
    public void logError(String format, Object ... args) {
        this.printTitle();
        if (this.lines < this.maxLines) {
            this.delegate.logError(format, args);
        }
        ++this.lines;
    }

    private void printTitle() {
        if (this.lines == 0) {
            this.delegate.logError("%s", this.title);
        }
    }

    @FormatMethod
    public void logException(Exception exception, String format, Object ... args) {
        this.printTitle();
        if (this.lines < this.maxLines) {
            this.delegate.logError(format, args);
            Arrays.stream(ExceptionUtils.getRootCauseStackTrace((Throwable)exception)).forEach(s -> this.delegate.logError("%s", s));
        }
        ++this.lines;
    }

    public int size() {
        return this.lines;
    }

    public void logSummary() {
        if (this.lines > this.maxLines) {
            this.delegate.logError(SKIPPED_MESSAGE, this.lines - this.maxLines);
        }
    }
}

