/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.Report;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

public class IssueDifference {
    private final Report newIssues;
    private final Report fixedIssues;
    private final Report outstandingIssues;

    public IssueDifference(Report currentIssues, String referenceId, Report referenceIssues) {
        this.newIssues = currentIssues.copy();
        this.fixedIssues = referenceIssues.copy();
        this.outstandingIssues = new Report();
        List<UUID> removed = this.matchIssuesByEquals(currentIssues);
        Report secondPass = currentIssues.copy();
        removed.forEach(secondPass::remove);
        this.matchIssuesByFingerprint(secondPass);
        this.newIssues.forEach(issue -> issue.setReference(referenceId));
    }

    private List<UUID> matchIssuesByEquals(Report currentIssues) {
        ArrayList<UUID> removedIds = new ArrayList<UUID>();
        for (Issue current : currentIssues) {
            List<Issue> equalIssues = this.findReferenceByEquals(current);
            if (equalIssues.isEmpty()) continue;
            removedIds.add(this.remove(current, this.selectIssueWithSameFingerprint(current, equalIssues)));
        }
        return removedIds;
    }

    private void matchIssuesByFingerprint(Report currentIssues) {
        for (Issue current : currentIssues) {
            this.findReferenceByFingerprint(current).ifPresent(issue -> this.remove(current, (Issue)issue));
        }
    }

    private UUID remove(Issue current, Issue oldIssue) {
        UUID id = current.getId();
        Issue issueWithLatestProperties = this.newIssues.remove(id);
        issueWithLatestProperties.setReference(oldIssue.getReference());
        this.outstandingIssues.add(issueWithLatestProperties);
        this.fixedIssues.remove(oldIssue.getId());
        return id;
    }

    private Issue selectIssueWithSameFingerprint(Issue current, List<Issue> equalIssues) {
        return equalIssues.stream().filter(issue -> issue.getFingerprint().equals(current.getFingerprint())).findFirst().orElse(equalIssues.get(0));
    }

    private Optional<Issue> findReferenceByFingerprint(Issue current) {
        for (Issue reference : this.fixedIssues) {
            if (!current.getFingerprint().equals(reference.getFingerprint())) continue;
            return Optional.of(reference);
        }
        return Optional.empty();
    }

    private List<Issue> findReferenceByEquals(Issue current) {
        ArrayList<Issue> equalIssues = new ArrayList<Issue>();
        for (Issue reference : this.fixedIssues) {
            if (!current.equals(reference)) continue;
            equalIssues.add(reference);
        }
        return equalIssues;
    }

    public Report getOutstandingIssues() {
        return this.outstandingIssues;
    }

    public Report getNewIssues() {
        return this.newIssues;
    }

    public Report getFixedIssues() {
        return this.fixedIssues;
    }
}

