/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import edu.hm.hafner.analysis.ParsingCanceledException;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import java.io.Serializable;
import java.util.stream.Stream;

public abstract class IssueParser
implements Serializable {
    private static final long serialVersionUID = 200992696185460268L;

    public abstract Report parse(ReaderFactory var1) throws ParsingException, ParsingCanceledException;

    public boolean accepts(ReaderFactory readerFactory) {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isXmlFile(ReaderFactory readerFactory) {
        try (Stream<String> lines = readerFactory.readStream();){
            boolean bl = lines.limit(10L).anyMatch(line -> line.contains("<?xml"));
            return bl;
        }
        catch (ParsingException ignored) {
            return false;
        }
    }
}

