/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import edu.hm.hafner.analysis.LineRange;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.stream.StreamSupport;

public class LineRangeList
extends AbstractList<LineRange>
implements Serializable {
    private static final long serialVersionUID = -1123973098942984623L;
    private static final int DEFAULT_CAPACITY = 16;
    private byte[] data;
    private int len;

    public LineRangeList() {
        this(16);
    }

    public LineRangeList(int capacity) {
        this.data = new byte[capacity];
        this.len = 0;
    }

    public LineRangeList(Collection<LineRange> copy) {
        this(copy.size() * 4);
        this.addAll((Collection<? extends LineRange>)copy);
    }

    public LineRangeList(LineRange ... initialElements) {
        this(initialElements.length * 4);
        for (LineRange element : initialElements) {
            this.add(element);
        }
    }

    @Override
    public final boolean addAll(Collection<? extends LineRange> c) {
        return super.addAll(c);
    }

    @Override
    public final boolean addAll(Iterable<? extends LineRange> ranges) {
        return StreamSupport.stream(ranges.spliterator(), false).map(this::add).reduce(Boolean::logicalOr).orElse(false);
    }

    private void ensure(int n) {
        if (this.data.length < n) {
            byte[] buf = new byte[Math.max(n, this.data.length * 2)];
            System.arraycopy(this.data, 0, buf, 0, this.len);
            this.data = buf;
        }
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof LineRange) {
            LineRange lr = (LineRange)o;
            Cursor c = new Cursor();
            while (c.hasNext()) {
                if (!c.compare(lr)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public LineRange get(int index) {
        return new Cursor().skip(index).next();
    }

    @Override
    public int size() {
        return new Cursor().count();
    }

    @Override
    public LineRange set(int index, LineRange element) {
        return new Cursor().skip(index).rewrite(element);
    }

    @Override
    public void add(int index, LineRange element) {
        new Cursor().skip(index).add(element);
    }

    @Override
    public final boolean add(LineRange lr) {
        new Cursor(this.len).add(lr);
        return true;
    }

    @Override
    public LineRange remove(int index) {
        return new Cursor().skip(index).delete();
    }

    @Override
    public void clear() {
        this.len = 0;
    }

    @Override
    public Iterator<LineRange> iterator() {
        return new Cursor();
    }

    @Override
    public ListIterator<LineRange> listIterator() {
        return new Cursor();
    }

    @Override
    public ListIterator<LineRange> listIterator(int index) {
        return new Cursor().skip(index);
    }

    public void trim() {
        if (this.len != this.data.length) {
            byte[] small = new byte[this.len];
            System.arraycopy(this.data, 0, small, 0, this.len);
            this.data = small;
        }
    }

    private class Cursor
    implements ListIterator<LineRange> {
        private int position;

        Cursor(int position) {
            this.position = position;
        }

        Cursor() {
            this(0);
        }

        private void prev() {
            if (this.position == 0) {
                throw new IllegalStateException("Cursor is a the beginning.");
            }
            do {
                --this.position;
            } while (this.position > 0 && (LineRangeList.this.data[this.position - 1] & 0x80) == 0);
        }

        @Override
        public LineRange next() {
            int s = this.read();
            int d = this.read();
            return new LineRange(s, s + d);
        }

        @Override
        public LineRange previous() {
            this.prev();
            this.prev();
            return this.copy().next();
        }

        @Override
        public void remove() {
            this.prev();
            this.prev();
            this.delete();
        }

        @Override
        public boolean hasNext() {
            return this.position < LineRangeList.this.len;
        }

        @Override
        public boolean hasPrevious() {
            return this.position > 0;
        }

        private int read() {
            if (LineRangeList.this.len <= this.position) {
                throw new IndexOutOfBoundsException("Position " + this.position + " is >= length " + LineRangeList.this.len);
            }
            int i = 0;
            int v = 0;
            do {
                v += (LineRangeList.this.data[this.position] & 0x7F) << i++ * 7;
            } while ((LineRangeList.this.data[this.position++] & 0x80) == 0);
            return v;
        }

        private void write(int index) {
            boolean last;
            int i = index;
            do {
                last = i < 128;
                ((LineRangeList)LineRangeList.this).data[this.position++] = (byte)(i & 0x7F | (last ? 128 : 0));
                i /= 128;
            } while (!last);
        }

        private void write(LineRange r) {
            this.write(r.getStart());
            this.write(r.getEnd() - r.getStart());
        }

        public boolean compare(LineRange other) {
            int s = this.read();
            int d = this.read();
            return other.getStart() == s && other.getEnd() == s + d;
        }

        private Cursor skip(int n) {
            for (int i = n; i > 0; --i) {
                this.read();
                this.read();
            }
            return this;
        }

        private int count() {
            int n = 0;
            while (this.position < LineRangeList.this.len) {
                this.read();
                this.read();
                ++n;
            }
            return n;
        }

        @Override
        public int nextIndex() {
            throw new UnsupportedOperationException("nextIndex is not supported");
        }

        @Override
        public int previousIndex() {
            throw new UnsupportedOperationException("previousIndex is not supported");
        }

        public Cursor copy() {
            return new Cursor(this.position);
        }

        private void adjust(int diff) {
            LineRangeList.this.ensure(LineRangeList.this.len + diff);
            if (diff > 0) {
                System.arraycopy(LineRangeList.this.data, this.position, LineRangeList.this.data, this.position + diff, LineRangeList.this.len - this.position);
            } else {
                System.arraycopy(LineRangeList.this.data, this.position - diff, LineRangeList.this.data, this.position, LineRangeList.this.len - this.position + diff);
            }
            LineRangeList.this.len += diff;
        }

        public LineRange rewrite(LineRange other) {
            Cursor c = this.copy();
            LineRange old = c.next();
            int oldSize = c.position - this.position;
            int newSize = this.sizeOf(other);
            this.adjust(newSize - oldSize);
            this.write(other);
            return old;
        }

        @Override
        public void set(LineRange v) {
            this.rewrite(v);
        }

        @Override
        public void add(LineRange v) {
            int newSize = this.sizeOf(v);
            this.adjust(newSize);
            this.write(v);
        }

        public LineRange delete() {
            Cursor c = this.copy();
            LineRange old = c.next();
            this.adjust(this.position - c.position);
            return old;
        }

        private int sizeOf(LineRange v) {
            return this.sizeOf(v.getStart()) + this.sizeOf(v.getEnd() - v.getStart());
        }

        private int sizeOf(int index) {
            int i = index;
            int n = 0;
            do {
                ++n;
            } while ((i /= 128) > 0);
            return n;
        }
    }
}

