/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.ParsingCanceledException;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.util.LookaheadStream;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public abstract class LookaheadParser
extends IssueParser {
    private static final long serialVersionUID = 3240719494150024894L;
    protected static final String ANT_TASK = "^(?:.*\\[[^]]*\\])?\\s*";
    private static final String ENTERING_DIRECTORY = "Entering directory";
    private static final Pattern MAKE_PATH = Pattern.compile(".*make(?:\\[\\d+])?: Entering directory [`'](?<dir>.*)['`]");
    private static final String CMAKE_PREFIX = "-- Build files have";
    private static final Pattern CMAKE_PATH = Pattern.compile("-- Build files have been written to: (?<dir>.*)");
    private final Pattern pattern;

    protected LookaheadParser(String pattern) {
        this.pattern = Pattern.compile(pattern);
    }

    @Override
    public Report parse(ReaderFactory readerFactory) throws ParsingException, ParsingCanceledException {
        Report report = new Report();
        try (Stream<String> lines = readerFactory.readStream();
             LookaheadStream lookahead = new LookaheadStream(lines, readerFactory.getFileName());){
            this.parse(report, lookahead);
        }
        return this.postProcess(report);
    }

    private void parse(Report report, LookaheadStream lookahead) {
        IssueBuilder builder = new IssueBuilder();
        while (lookahead.hasNext()) {
            Matcher matcher;
            String line = lookahead.next();
            if (line.contains(ENTERING_DIRECTORY)) {
                this.extractAndStoreDirectory(builder, line, MAKE_PATH);
            } else if (line.contains(CMAKE_PREFIX)) {
                this.extractAndStoreDirectory(builder, line, CMAKE_PATH);
            } else if (this.isLineInteresting(line) && (matcher = this.pattern.matcher(line)).find()) {
                this.createIssue(matcher, lookahead, builder).ifPresent(report::add);
            }
            if (!Thread.interrupted()) continue;
            throw new ParsingCanceledException();
        }
    }

    private void extractAndStoreDirectory(IssueBuilder builder, String line, Pattern makePath) {
        Matcher makeLineMatcher = makePath.matcher(line);
        if (makeLineMatcher.matches()) {
            builder.setDirectory(makeLineMatcher.group("dir"));
        }
    }

    protected abstract Optional<Issue> createIssue(Matcher var1, LookaheadStream var2, IssueBuilder var3) throws ParsingException;

    protected boolean isLineInteresting(String line) {
        return true;
    }

    protected Report postProcess(Report report) {
        return report;
    }
}

