/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class AjcParser
extends IssueParser {
    private static final long serialVersionUID = -9123765511497052454L;
    private static final Pattern ESCAPE_CHARACTERS = Pattern.compile("\u001b\\[.*\u001b\\[0m");
    private static final String WARNING_TAG = "[WARNING] ";
    static final String ADVICE = "Advice";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Report parse(ReaderFactory reader) throws ParsingException {
        try (Stream<String> lines = reader.readStream();){
            Report report = this.parse(lines);
            return report;
        }
        catch (UncheckedIOException e) {
            throw new ParsingException(e);
        }
    }

    private Report parse(Stream<String> lines) {
        Report warnings = new Report();
        States state = States.START;
        IssueBuilder builder = new IssueBuilder();
        Iterator lineIterator = lines.iterator();
        while (lineIterator.hasNext()) {
            String line = (String)lineIterator.next();
            line = ESCAPE_CHARACTERS.matcher(line).replaceAll("");
            switch (state) {
                case START: {
                    if (!line.startsWith("[INFO] Showing AJC message detail for messages of types")) break;
                    state = States.PARSING;
                    break;
                }
                case PARSING: {
                    if (!line.startsWith(WARNING_TAG)) break;
                    line = line.substring(WARNING_TAG.length());
                    state = States.WAITING_FOR_END;
                    this.fillMessageAndCategory(builder, line);
                    break;
                }
                case WAITING_FOR_END: {
                    if (line.startsWith("\t")) {
                        this.fillFileName(builder, line);
                        break;
                    }
                    if (!"".equals(line)) break;
                    state = States.PARSING;
                    warnings.add(builder.build());
                }
            }
        }
        return warnings;
    }

    private void fillFileName(IssueBuilder builder, String line) {
        int indexOfColon = line.lastIndexOf(58);
        if (indexOfColon != -1) {
            builder.setFileName(line.substring(0, indexOfColon));
            if (line.length() > indexOfColon + 1) {
                builder.setLineStart(line.substring(indexOfColon + 1));
            }
        }
    }

    private void fillMessageAndCategory(IssueBuilder builder, String line) {
        String category = line.contains("is deprecated") || line.contains("overrides a deprecated") ? "Deprecation" : (line.contains("adviceDidNotMatch") ? ADVICE : "");
        builder.setMessage(line);
        builder.setCategory(category);
    }

    private static enum States {
        START,
        PARSING,
        WAITING_FOR_END;

    }
}

