/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.ParsingCanceledException;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import java.util.Optional;
import java.util.stream.Stream;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

public class CargoCheckParser
extends IssueParser {
    private static final long serialVersionUID = 7953467739178377581L;
    private static final String ANALYSIS_MESSAGE_REASON = "compiler-message";
    private static final String REASON = "reason";
    private static final String MESSAGE = "message";
    private static final String MESSAGE_CODE = "code";
    private static final String MESSAGE_CODE_CATEGORY = "code";
    private static final String MESSAGE_RENDERED = "message";
    private static final String MESSAGE_LEVEL = "level";
    private static final String MESSAGE_SPANS = "spans";
    private static final String MESSAGE_SPAN_IS_PRIMARY = "is_primary";
    private static final String MESSAGE_SPAN_FILE_NAME = "file_name";
    private static final String MESSAGE_SPAN_LINE_START = "line_start";
    private static final String MESSAGE_SPAN_LINE_END = "line_end";
    private static final String MESSAGE_SPAN_COLUMN_START = "column_start";
    private static final String MESSAGE_SPAN_COLUMN_END = "column_end";

    @Override
    public Report parse(ReaderFactory readerFactory) throws ParsingException, ParsingCanceledException {
        Report report = new Report();
        try (Stream<String> lines = readerFactory.readStream();){
            lines.map(line -> (JSONObject)new JSONTokener(line).nextValue()).map(this::extractIssue).filter(Optional::isPresent).map(Optional::get).forEach(report::add);
        }
        return report;
    }

    private Optional<Issue> extractIssue(JSONObject object) {
        String reason = object.getString(REASON);
        if (!ANALYSIS_MESSAGE_REASON.equals(reason)) {
            return Optional.empty();
        }
        JSONObject message = object.getJSONObject("message");
        JSONObject code = message.getJSONObject("code");
        String category = code.getString("code");
        String renderedMessage = message.getString("message");
        Severity severity = Severity.guessFromString(message.getString(MESSAGE_LEVEL));
        return this.parseDetails(message).map(details -> new IssueBuilder().setFileName(((CompilerMessageDetails)details).fileName).setLineStart(((CompilerMessageDetails)details).lineStart).setLineEnd(((CompilerMessageDetails)details).lineEnd).setColumnStart(((CompilerMessageDetails)details).columnStart).setColumnEnd(((CompilerMessageDetails)details).columnEnd).setCategory(category).setMessage(renderedMessage).setSeverity(severity).build());
    }

    private Optional<CompilerMessageDetails> parseDetails(JSONObject message) {
        JSONArray spans = message.getJSONArray(MESSAGE_SPANS);
        for (int index = 0; index < spans.length(); ++index) {
            JSONObject span = spans.getJSONObject(index);
            if (!span.getBoolean(MESSAGE_SPAN_IS_PRIMARY)) continue;
            String fileName = span.getString(MESSAGE_SPAN_FILE_NAME);
            int lineStart = span.getInt(MESSAGE_SPAN_LINE_START);
            int lineEnd = span.getInt(MESSAGE_SPAN_LINE_END);
            int columnStart = span.getInt(MESSAGE_SPAN_COLUMN_START);
            int columnEnd = span.getInt(MESSAGE_SPAN_COLUMN_END);
            return Optional.of(new CompilerMessageDetails(fileName, lineStart, lineEnd, columnStart, columnEnd));
        }
        return Optional.empty();
    }

    private static final class CompilerMessageDetails {
        private final String fileName;
        private final int lineStart;
        private final int lineEnd;
        private final int columnStart;
        private final int columnEnd;

        CompilerMessageDetails(String fileName, int lineStart, int lineEnd, int columnStart, int columnEnd) {
            this.fileName = fileName;
            this.lineStart = lineStart;
            this.lineEnd = lineEnd;
            this.columnStart = columnStart;
            this.columnEnd = columnEnd;
        }
    }
}

