/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.RegexpLineParser;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.IntegerParser;
import java.util.Optional;
import java.util.regex.Matcher;

public class CppLintParser
extends RegexpLineParser {
    private static final long serialVersionUID = 1737791073711198075L;
    private static final String PATTERN = "^\\s*(.*)\\s*[(:](\\d+)\\)?:\\s*(.*)\\s*\\[(.*)\\] \\[(.*)\\]$";
    private static final int SEVERITY_HIGH_LIMIT = 5;
    private static final int SEVERITY_NORMAL_LIMIT = 3;

    public CppLintParser() {
        super(PATTERN);
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, IssueBuilder builder) {
        Severity priority = this.mapPriority(matcher.group(5));
        return builder.setFileName(matcher.group(1)).setLineStart(matcher.group(2)).setCategory(matcher.group(4)).setMessage(matcher.group(3)).setSeverity(priority).buildOptional();
    }

    private Severity mapPriority(String priority) {
        int value = IntegerParser.parseInt(priority);
        if (value >= 5) {
            return Severity.WARNING_HIGH;
        }
        if (value >= 3) {
            return Severity.WARNING_NORMAL;
        }
        return Severity.WARNING_LOW;
    }
}

